package cn.com.poc.law.rest.impl;	

import java.util.List;
import javax.annotation.Resource;

import cn.com.poc.common.utils.BlContext;
import cn.com.poc.law.dto.SaveTemplateDataDto;
import cn.com.poc.law.dto.TemplateCallDto;
import cn.com.poc.law.dto.TemplateDataDetailDto;
import cn.com.poc.support.security.oauth.entity.UserBaseEntity;
import cn.com.yict.framemax.core.exception.BusinessException;
import org.springframework.stereotype.Component;
import cn.com.poc.law.rest.BizAiLawyerWritingTemplateDataRest;
import cn.com.poc.law.service.BizAiLawyerWritingTemplateDataService;
import cn.com.poc.law.dto.BizAiLawyerWritingTemplateDataDto;
import cn.com.poc.law.entity.BizAiLawyerWritingTemplateDataEntity;
import cn.com.yict.framemax.data.model.PagingInfo;
import cn.com.poc.law.convert.BizAiLawyerWritingTemplateDataConvert;
import java.util.stream.Collectors;
import org.springframework.util.Assert;

@Component
public class BizAiLawyerWritingTemplateDataRestImpl implements BizAiLawyerWritingTemplateDataRest {
   
   	@Resource
    private BizAiLawyerWritingTemplateDataService service;
    			 
	public BizAiLawyerWritingTemplateDataDto getById(java.lang.Integer id) throws Exception{
		Assert.notNull(id);
 		return BizAiLawyerWritingTemplateDataConvert.entityToDto(service.get(id));
   	}
    
   	public List<BizAiLawyerWritingTemplateDataDto> getList(BizAiLawyerWritingTemplateDataDto dto,PagingInfo pagingInfo) throws Exception{
       	return service
		        .findByExample(BizAiLawyerWritingTemplateDataConvert.dtoToEntity(dto),pagingInfo)
		        .stream()
				.map(BizAiLawyerWritingTemplateDataConvert::entityToDto)
				.collect(Collectors.toList());
   	}

   	public BizAiLawyerWritingTemplateDataDto save(BizAiLawyerWritingTemplateDataDto dto) throws Exception{
		Assert.notNull(dto);
		BizAiLawyerWritingTemplateDataEntity entity = BizAiLawyerWritingTemplateDataConvert.dtoToEntity(dto);
       	return BizAiLawyerWritingTemplateDataConvert.entityToDto(service.save(entity));
   	}
    
	
    public BizAiLawyerWritingTemplateDataDto update(BizAiLawyerWritingTemplateDataDto dto) throws Exception{
		Assert.notNull(dto);
		BizAiLawyerWritingTemplateDataEntity entity = BizAiLawyerWritingTemplateDataConvert.dtoToEntity(dto);
       	return BizAiLawyerWritingTemplateDataConvert.entityToDto(service.update(entity));
	}

    public void deletedById(java.lang.Integer id) throws Exception{
		Assert.notNull(id);
		service.deletedById(id);
	}

	@Override
	public void updateTemplateData(SaveTemplateDataDto saveTemplateDataDto) throws Exception {
		Assert.notNull(saveTemplateDataDto);
		service.updateTemplateData(saveTemplateDataDto.getRecordId(),saveTemplateDataDto.getData());
	}

	@Override
	public String downloadTemplateData(Long recordId) throws Exception {
		return service.downloadTemplateData( recordId);
	}

	@Override
	public TemplateDataDetailDto getTemplateDataDetail(String dialoguesId) throws Exception {
		UserBaseEntity userBaseEntity = BlContext.getCurrentUserNotException();
		if (userBaseEntity == null) {
			throw new BusinessException("用户未登录");
		}
		return service.getTemplateDataDetail(dialoguesId,userBaseEntity.getUserId(),true);
	}


}