package cn.com.poc.law.rest.impl;	

import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;
import cn.com.poc.law.rest.BizAiLawyerWritingTemplateDownloadRest;
import cn.com.poc.law.service.BizAiLawyerWritingTemplateDownloadService;
import cn.com.poc.law.dto.BizAiLawyerWritingTemplateDownloadDto;
import cn.com.poc.law.entity.BizAiLawyerWritingTemplateDownloadEntity;
import cn.com.yict.framemax.data.model.PagingInfo;
import cn.com.poc.law.convert.BizAiLawyerWritingTemplateDownloadConvert;
import java.util.stream.Collectors;
import org.springframework.util.Assert;

@Component
public class BizAiLawyerWritingTemplateDownloadRestImpl implements BizAiLawyerWritingTemplateDownloadRest {
   
   	@Resource
    private BizAiLawyerWritingTemplateDownloadService service;
    			 
	public BizAiLawyerWritingTemplateDownloadDto getById(java.lang.Long id) throws Exception{
		Assert.notNull(id);
 		return BizAiLawyerWritingTemplateDownloadConvert.entityToDto(service.get(id));
   	}
    
   	public List<BizAiLawyerWritingTemplateDownloadDto> getList(BizAiLawyerWritingTemplateDownloadDto dto,PagingInfo pagingInfo) throws Exception{
       	return service
		        .findByExample(BizAiLawyerWritingTemplateDownloadConvert.dtoToEntity(dto),pagingInfo)
		        .stream()
				.map(BizAiLawyerWritingTemplateDownloadConvert::entityToDto)
				.collect(Collectors.toList());
   	}

   	public BizAiLawyerWritingTemplateDownloadDto save(BizAiLawyerWritingTemplateDownloadDto dto) throws Exception{
		Assert.notNull(dto);
		BizAiLawyerWritingTemplateDownloadEntity entity = BizAiLawyerWritingTemplateDownloadConvert.dtoToEntity(dto);
       	return BizAiLawyerWritingTemplateDownloadConvert.entityToDto(service.save(entity));
   	}
    
	
    public BizAiLawyerWritingTemplateDownloadDto update(BizAiLawyerWritingTemplateDownloadDto dto) throws Exception{
		Assert.notNull(dto);
		BizAiLawyerWritingTemplateDownloadEntity entity = BizAiLawyerWritingTemplateDownloadConvert.dtoToEntity(dto);
       	return BizAiLawyerWritingTemplateDownloadConvert.entityToDto(service.update(entity));
	}

    public void deletedById(java.lang.Long id) throws Exception{
		Assert.notNull(id);
		service.deletedById(id);
	}
}