package cn.com.poc.law.rest.impl;

import java.util.List;
import javax.annotation.Resource;

import cn.com.poc.law.aggregate.AiLawyerWritingTemplateService;
import cn.com.poc.law.dto.AiLawyerWritingTemplateResult;
import org.springframework.stereotype.Component;
import cn.com.poc.law.rest.BizAiLawyerWritingTemplateRest;
import cn.com.poc.law.service.BizAiLawyerWritingTemplateService;
import cn.com.poc.law.dto.BizAiLawyerWritingTemplateDto;
import cn.com.poc.law.entity.BizAiLawyerWritingTemplateEntity;
import cn.com.yict.framemax.data.model.PagingInfo;
import cn.com.poc.law.convert.BizAiLawyerWritingTemplateConvert;

import java.util.stream.Collectors;

import org.springframework.util.Assert;

@Component
public class BizAiLawyerWritingTemplateRestImpl implements BizAiLawyerWritingTemplateRest {

    @Resource
    private BizAiLawyerWritingTemplateService service;

    @Resource
    private AiLawyerWritingTemplateService aiLawyerWritingTemplateService;


    public AiLawyerWritingTemplateResult getTemplateWritingList() throws Exception {
        return aiLawyerWritingTemplateService.getTemplateWritingList();
    }

    /**
     * 根据类型获取模板
     *
     * @param templateType@return
     * @throws Exception
     */
    @Override
    public List<BizAiLawyerWritingTemplateDto> getByType(String templateType) throws Exception {
        cn.com.poc.common.utils.Assert.notBlank(templateType);
        return service.getByType(templateType).stream()
                .map(BizAiLawyerWritingTemplateConvert::entityToDto)
                .collect(Collectors.toList());
    }

}