package cn.com.poc.law.rest.impl;

import cn.com.poc.common.utils.BlContext;
import cn.com.poc.law.dto.AiLawDialoguesDto;
import cn.com.poc.law.dto.LegislativeDocumentDto;
import cn.com.poc.law.entity.legislativeDocument.LegislativeDocumentResult;
import cn.com.poc.law.rest.BizAiLegislativeDocumentWritingRest;
import cn.com.poc.law.service.BizAiLegislativeDocumentWritingService;
import cn.com.poc.support.security.oauth.entity.UserBaseEntity;
import cn.com.yict.framemax.core.exception.BusinessException;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Component
public class BizAiLegislativeDocumentWritingRestImpl implements BizAiLegislativeDocumentWritingRest {

    @Resource
    private BizAiLegislativeDocumentWritingService service;

    /**
     * 立案调查保存
     *
     * @param dto
     * @return
     */
    @Override
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public LegislativeDocumentResult legislativeApply(AiLawDialoguesDto dto) throws Exception {
        UserBaseEntity userBaseEntity = BlContext.getCurrentUserNotException();
        if (userBaseEntity == null) {
            throw new BusinessException("用户未登录");
        }
        return service.call(dto.getDialoguesId(), dto.getInput(), dto.getFileUrl(), userBaseEntity.getUserId());
    }

    /**
     * 获取立案调查详情
     *
     * @param dialoguesId
     * @return
     */
    @Override
    public LegislativeDocumentResult getLegislativeApplyDetail(String dialoguesId) throws Exception {
        UserBaseEntity userBaseEntity = BlContext.getCurrentUserNotException();
        if (userBaseEntity == null) {
            throw new BusinessException("用户未登录");
        }
        return service.getlegislativeApplyDetail(dialoguesId, userBaseEntity.getUserId());
    }

    /**
     * 保存立案调查
     *
     * @param legislativeDocumentDto
     */
    @Override
    public void saveLegislativeApply(LegislativeDocumentDto legislativeDocumentDto) throws Exception {
        UserBaseEntity userBaseEntity = BlContext.getCurrentUserNotException();
        if (userBaseEntity == null) {
            throw new BusinessException("用户未登录");
        }
        service.saveLegislativeApply(legislativeDocumentDto.getDialoguesId(), legislativeDocumentDto.getLegislativeDocumentResult());
    }
}