package cn.com.poc.law.rest.impl;

import cn.com.poc.common.utils.Assert;
import cn.com.poc.common.utils.BlContext;
import cn.com.poc.law.dto.AiLawDialoguesDto;
import cn.com.poc.law.dto.LegalFileDto;
import cn.com.poc.law.dto.TemplateCallDto;
import cn.com.poc.law.rest.LegalRest;
import cn.com.poc.law.service.AiLawService;
import cn.com.poc.support.security.oauth.entity.UserBaseEntity;
import cn.com.poc.thirdparty.resource.demand.ai.aggregate.LegalService;
import cn.com.poc.thirdparty.resource.demand.ai.entity.legal.LegalFileResponse;
import cn.com.poc.thirdparty.resource.demand.ai.entity.legal.LegalFileResult;
import cn.com.yict.framemax.core.exception.BusinessException;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * @author alex.yao
 * @date 2025/7/28
 */
@Component
public class LegalRestImpl implements LegalRest {

    @Resource
    private LegalService legalService;

    @Override
    public String legalFileQuery(LegalFileDto legalFileDto) {
        Assert.notNull(legalFileDto, "法律文件查询参数不能为空");
        Assert.notBlank(legalFileDto.getFilePath(), "文件路径不能为空");
        Assert.notEmpty(legalFileDto.getItems(), "文件项不能为空");

        LegalFileResponse response = new LegalFileResponse();
        response.setFilePath(legalFileDto.getFilePath());
        response.setItems(legalFileDto.getItems());
        LegalFileResult legalFileResult = legalService.legalFile(response);
        if (legalFileResult == null) {
            throw new BusinessException("法律文件查询失败");
        }
        return legalFileResult.getFilePath();
    }

    @Resource
    private AiLawService aiLawService;

    @Override
    public void aiWritingCall(AiLawDialoguesDto dto) throws Exception {
        cn.hutool.core.lang.Assert.notNull(dto.getDialoguesId(), "对话id不能为空");
        cn.hutool.core.lang.Assert.notNull(dto.getInput(), "问题不能为空");
        UserBaseEntity userBaseEntity = BlContext.getCurrentUserNotException();
        if (userBaseEntity == null) {
            throw new BusinessException("用户未登录");
        }

        aiLawService.aiWritingCall(dto.getDialoguesId(), dto.getInput(), dto.getEnableSearchEngine(), dto.getEnableDeepThinking(), dto.getFileUrl(), dto.getKnowledgeIds(), dto.getDatabaseIds(), userBaseEntity.getUserId());
    }

    /**
     * templateAi对话
     *
     * @param dto
     */
    @Override
    public TemplateCallDto templateCall(AiLawDialoguesDto dto) throws Exception {
        UserBaseEntity userBaseEntity = BlContext.getCurrentUserNotException();
        if (userBaseEntity == null) {
            throw new BusinessException("用户未登录");
        }
        return aiLawService.templateCall(dto.getDialoguesId(), dto.getTemplateCode(), dto.getInput(), dto.getFileUrl(), dto.getIfCover(), userBaseEntity.getUserId());
    }
}
