package cn.com.poc.law.service;

import cn.com.poc.law.dto.TemplateCallDto;

/**
 * AI财务
 *
 * @author alex.yao
 * @date 2025/6/20
 */
public interface AiLawService {

    /**
     * 调用AI服务
     *
     * @param dialoguesId        对话id
     * @param input              问题
     * @param fileUrl            文件地址
     * @param enableSearchEngine 是否开启联网检索
     * @param enableDeepThinking 是否开启思考模式
     * @param knowledgeIds       知识库ids
     * @param databaseIds        数据库ids
     * @param userId             用户id
     */
    void aiWritingCall(String dialoguesId, String input, boolean enableSearchEngine, boolean enableDeepThinking, String fileUrl, Integer[] knowledgeIds, Integer[] databaseIds, Long userId) throws Exception;

    /**
     * @throws Exception
     */
    TemplateCallDto templateCall(String dialoguesId, String templateCode, String input, String fileUrl, boolean ifCover, Long userId) throws Exception;
}
