package cn.com.poc.law.service.impl;

import cn.com.poc.agent_application.entity.*;
import cn.com.poc.agent_application.service.BizAgentApplicationDialoguesRecordService;
import cn.com.poc.agent_application.service.BizAgentApplicationGcConfigService;
import cn.com.poc.agent_application.utils.AgentApplicationTools;
import cn.com.poc.ai_dialogues.constant.AiDialoguesTypeEnum;
import cn.com.poc.ai_dialogues.entity.BizAiDialoguesEntity;
import cn.com.poc.ai_dialogues.service.BizAiDialoguesService;
import cn.com.poc.common.constant.CommonConstant;
import cn.com.poc.common.utils.DocumentLoad;
import cn.com.poc.common.utils.JsonUtils;
import cn.com.poc.common.utils.SSEUtil;
import cn.com.poc.law.dto.TemplateDataDetailDto;
import cn.com.poc.law.entity.BizAiLawyerWritingTemplateDataEntity;
import cn.com.poc.law.extractEntityStrategy.ExtractEntityStrategy;
import cn.com.poc.law.extractEntityStrategy.LawyerExtractTypeConstants;
import cn.com.poc.law.extractEntityStrategy.LawyerTemplateExtractServiceBuilder;
import cn.com.poc.law.dto.LegalTemplateDto;
import cn.com.poc.law.dto.TemplateCallDto;
import cn.com.poc.law.service.AiLawService;
import cn.com.poc.law.service.BizAiLawyerWritingTemplateDataService;
import cn.com.poc.long_document.domain.LongtextDialoguesResult;
import cn.com.poc.thirdparty.resource.demand.ai.constants.LLMRoleEnum;
import cn.com.poc.thirdparty.resource.demand.ai.entity.dialogue.FunctionCall;
import cn.com.poc.thirdparty.resource.demand.ai.entity.dialogue.Message;
import cn.com.poc.thirdparty.resource.demand.ai.entity.dialogue.Tool;
import cn.com.poc.thirdparty.resource.demand.ai.entity.dialogue.ToolFunction;
import cn.com.poc.thirdparty.resource.demand.ai.entity.function.FunctionCallResult;
import cn.com.poc.thirdparty.resource.demand.ai.entity.largemodel.LargeModelDemandResult;
import cn.com.poc.thirdparty.resource.demand.ai.entity.largemodel.LargeModelResponse;
import cn.com.poc.thirdparty.resource.demand.ai.function.AbstractFunctionResult;
import cn.com.poc.thirdparty.resource.demand.ai.function.web_seach.WebSearchFunction;
import cn.com.poc.thirdparty.resource.demand.ai.function.web_seach.WebSearchFunctionResult;
import cn.com.poc.thirdparty.service.LLMService;
import cn.com.poc.writing.dto.AiWritingTitleGenerationDto;
import cn.com.yict.framemax.core.exception.BusinessException;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * @author alex.yao
 * @date 2025/6/20
 */
@Service
public class AiLawServiceImpl implements AiLawService {

    private final Logger logger = LoggerFactory.getLogger(AiLawServiceImpl.class);


    @Resource
    private BizAiDialoguesService bizAiDialoguesService;

    @Resource
    private LLMService llmService;

    @Resource
    private BizAgentApplicationDialoguesRecordService bizAgentApplicationDialoguesRecordService;

    @Resource
    private WebSearchFunction webSearchFunction;

    @Resource
    private BizAgentApplicationGcConfigService bizAgentApplicationGcConfigService;

    @Resource
    LawyerTemplateExtractServiceBuilder lawyerTemplateExtractServiceBuilder;

    @Resource
    BizAiLawyerWritingTemplateDataService bizAiLawyerWritingTemplateDataService;

    @Override
    public void aiWritingCall(String dialoguesId, String input, boolean enableSearchEngine, boolean enableDeepThinking, String fileUrl, Integer[] knowledgeIds, Integer[] databaseIds, Long userId) throws Exception {
        BizAiDialoguesEntity bizAiDialoguesEntity = new BizAiDialoguesEntity();
        bizAiDialoguesEntity.setDialoguesId(dialoguesId);
        bizAiDialoguesEntity.setMemberId(userId);
        bizAiDialoguesEntity.setIsDeleted(CommonConstant.IsDeleted.N);
        List<BizAiDialoguesEntity> bizAiDialoguesEntities = bizAiDialoguesService.findByExample(bizAiDialoguesEntity, null);
        if (CollectionUtils.isEmpty(bizAiDialoguesEntities)) {
            throw new BusinessException("当前对话不存在");
        }
        BizAiDialoguesEntity aiDialoguesEntity = bizAiDialoguesEntities.get(0);
        if (StringUtils.isBlank(aiDialoguesEntity.getTitle())) {
            aiDialoguesEntity.setTitle(input);
            aiDialoguesEntity.setDialoguesType(AiDialoguesTypeEnum.AI_LEGAL_DOCUMENT_WRITING.getType());
            bizAiDialoguesService.update(aiDialoguesEntity);
        }

        //记录提问时间
        long inputTimestamp = System.currentTimeMillis();
        SSEUtil sseUtil = new SSEUtil();
        // 知识库
        //获取知识库配置
//        List<Integer> kdIds = knowledgeService.getKdIdsByKnowledgeInfoIds(knowledgeIds);
//        List<KnowledgeContentResult> knowledgeResult = knowledge(kdIds, input, 5, 0.5, KnowledgeSearchTypeEnum.MIX);

//        if (CollectionUtils.isNotEmpty(knowledgeResult)) {
//            LargeModelDemandResult result = new LargeModelDemandResult();
//            result.setCode("0");
//            result.setFunction(null);
//            result.setDbChainResult(null);
//            result.setKnowledgeContentResult(knowledgeResult);
//            sseUtil.send(JsonUtils.serialize(result));
//        }

        // 插件调用
        ToolFunction toolFunction = null;
        if (enableSearchEngine) {
            List<Message> messages = new ArrayList<>();
            Message message = new Message();
            message.setRole("user");
            message.setContent(input);
            messages.add(message);

            String[] unitIds = new String[1];
            unitIds[0] = "web_search";
            List<Tool> tools = AgentApplicationTools.buildFunctionConfig(null, "N", dialoguesId, dialoguesId, unitIds, "N");
            CheckPluginUseEntity checkPluginUseEntity = AgentApplicationTools.checkPluginUse(messages, tools, null);
            FunctionCallResult functionCallResult = checkPluginUseEntity.getFunctionCallResult();
            if (functionCallResult != null && functionCallResult.isNeed()) {
                FunctionCall functionCall = functionCallResult.getFunctionCall();
                if ("web_search".equals(functionCall.getName())) {
                    AbstractFunctionResult<List<WebSearchFunctionResult>> functionResult = webSearchFunction.doFunction(functionCall.getArguments(), dialoguesId, null, null);
                    if (functionResult != null && CollectionUtils.isNotEmpty(functionResult.getFunctionResult())) {
                        List<WebSearchFunctionResult> webSearchFunctionResults = functionResult.getFunctionResult();
                        if (CollectionUtils.isNotEmpty(webSearchFunctionResults)) {
                            toolFunction = new ToolFunction();
                            toolFunction.setResult(JsonUtils.serialize(webSearchFunctionResults));
                            toolFunction.setName("web_search");
                            toolFunction.setArguments(functionCall.getArguments());
                            toolFunction.setDisplayFormat("json");
                            LargeModelDemandResult result = new LargeModelDemandResult();
                            result.setCode("0");
                            result.setFunction(toolFunction);
                            result.setDbChainResult(null);
                            result.setKnowledgeContentResult(null);
                            sseUtil.send(JsonUtils.serialize(result));
                        }
                    }
                }
            }
        }

        //作文标题生成
        AiWritingTitleGenerationDto aiWritingTitleGenerationDto = titleGeneration(input);
        Boolean needWriting = aiWritingTitleGenerationDto.getNeedWriting();
        if (needWriting && StringUtils.isNotBlank(aiWritingTitleGenerationDto.getTitle())) {
            sseUtil.send(JsonUtils.serialize(aiWritingTitleGenerationDto));
        }

        //组装请求参数
        List<Message> messages = buildMessages(dialoguesId, userId, input, fileUrl, null, toolFunction);
        LargeModelResponse largeModelResponse = new LargeModelResponse();
        largeModelResponse.setModel(enableDeepThinking ? "deepseek-chat" : "deepseek-v3");//获取模型);
        largeModelResponse.setMessages(messages.toArray(new Message[0]));
        largeModelResponse.setStream(true);
        BufferedReader bufferedReader = llmService.chatChunk(largeModelResponse);
        LongtextDialoguesResult longtextDialoguesResult = textOutputStream(sseUtil, bufferedReader);

        // 保存用户输入记录
        BizAgentApplicationDialoguesRecordEntity inputRecord = new BizAgentApplicationDialoguesRecordEntity();
        inputRecord.setMemberId(userId);
        inputRecord.setContent(input);
        inputRecord.setDialogsId(dialoguesId);
        inputRecord.setRole(LLMRoleEnum.USER.getRole());
        inputRecord.setTimestamp(inputTimestamp);

        // 保存AI回复记录
        BizAgentApplicationDialoguesRecordEntity assistantRecord = new BizAgentApplicationDialoguesRecordEntity();
        assistantRecord.setMemberId(userId);
        assistantRecord.setContent(longtextDialoguesResult.getMessage());
        assistantRecord.setReasoningContent(longtextDialoguesResult.getReasoningContent());
        assistantRecord.setDialogsId(dialoguesId);
        assistantRecord.setRole(LLMRoleEnum.ASSISTANT.getRole());
        assistantRecord.setTimestamp(System.currentTimeMillis());

        bizAgentApplicationDialoguesRecordService.save(inputRecord);
        bizAgentApplicationDialoguesRecordService.save(assistantRecord);
    }

    /**
     * @param dialoguesId
     * @param templateCode
     * @param input
     * @param fileUrl
     * @param userId
     * @throws Exception
     */
    @Override
    public TemplateCallDto templateCall(String dialoguesId, String templateCode, String input, String fileUrl, boolean ifCover, Long userId) throws Exception {

        //基础
        BizAiDialoguesEntity bizAiDialoguesEntity = new BizAiDialoguesEntity();
        bizAiDialoguesEntity.setDialoguesId(dialoguesId);
        bizAiDialoguesEntity.setMemberId(userId);
        bizAiDialoguesEntity.setIsDeleted(CommonConstant.IsDeleted.N);
        List<BizAiDialoguesEntity> bizAiDialoguesEntities = bizAiDialoguesService.findByExample(bizAiDialoguesEntity, null);
        if (CollectionUtils.isEmpty(bizAiDialoguesEntities)) {
            throw new BusinessException("当前对话不存在");
        }
        BizAiDialoguesEntity aiDialoguesEntity = bizAiDialoguesEntities.get(0);
        if (StringUtils.isBlank(aiDialoguesEntity.getTitle())) {
            aiDialoguesEntity.setDialoguesType(AiDialoguesTypeEnum.TEMPLATE_LEGAL_DOCUMENT_WRITING.getType());
            aiDialoguesEntity.setTitle(input);
            bizAiDialoguesService.update(aiDialoguesEntity);
        }
        // 加载文件
        String fileContent = StringUtils.EMPTY;
        if (StringUtils.isNoneBlank(fileUrl)) {
            File file = DocumentLoad.downloadURLDocument(fileUrl);
            fileContent = DocumentLoad.documentToText(file);
        }

        ExtractEntityStrategy extractEntityStrategy = lawyerTemplateExtractServiceBuilder.getService(LawyerExtractTypeConstants.LawyerExtractTypeEnum.get(templateCode));
        LegalTemplateDto legalTemplateDto = extractEntityStrategy.extractEntity(input + fileContent);

        LegalTemplateDto returnLegalTemplateDto = legalTemplateDto;
        TemplateDataDetailDto templateDataDetail = bizAiLawyerWritingTemplateDataService.getTemplateDataDetail(dialoguesId, userId, false);
        if (!ifCover && templateDataDetail != null) {
            LegalTemplateDto oldLegalTemplateDto = templateDataDetail.getLegalTemplateDto();
            JSONObject legalTemplateDtoJsonObject = JSONObject.parseObject(JsonUtils.serialize(legalTemplateDto));
            JSONObject oldLegalTemplateDtoJsonObject = JSONObject.parseObject(JsonUtils.serialize(oldLegalTemplateDto));
            JsonUtils.deepMerge(legalTemplateDtoJsonObject, oldLegalTemplateDtoJsonObject);
            returnLegalTemplateDto = oldLegalTemplateDtoJsonObject.toJavaObject(LegalTemplateDto.class);
        }

        long inputTimestamp = System.currentTimeMillis();
        // 保存对话
        // 保存用户输入记录
        BizAgentApplicationDialoguesRecordEntity inputRecord = new BizAgentApplicationDialoguesRecordEntity();
        inputRecord.setMemberId(userId);
        inputRecord.setContent(input);
        inputRecord.setDialogsId(dialoguesId);
        inputRecord.setRole(LLMRoleEnum.USER.getRole());
        inputRecord.setTimestamp(inputTimestamp);

        // 保存AI回复记录
        BizAgentApplicationDialoguesRecordEntity assistantRecord = new BizAgentApplicationDialoguesRecordEntity();
        assistantRecord.setMemberId(userId);
        assistantRecord.setContent(JsonUtils.serialize(legalTemplateDto));
        assistantRecord.setReasoningContent(null);
        assistantRecord.setDialogsId(dialoguesId);
        assistantRecord.setRole(LLMRoleEnum.ASSISTANT.getRole());
        assistantRecord.setTimestamp(inputTimestamp);

        bizAgentApplicationDialoguesRecordService.save(inputRecord);
        BizAgentApplicationDialoguesRecordEntity save = bizAgentApplicationDialoguesRecordService.save(assistantRecord);

        //保存多一份数据id表
        BizAiLawyerWritingTemplateDataEntity bizAiLawyerWritingTemplateDataEntity = new BizAiLawyerWritingTemplateDataEntity();
        bizAiLawyerWritingTemplateDataEntity.setBizAiLawyerWritingTemplateDialoguesId(dialoguesId);
        bizAiLawyerWritingTemplateDataEntity.setBizAiLawyerWritingTemplateData(JsonUtils.serialize(returnLegalTemplateDto));
        bizAiLawyerWritingTemplateDataEntity.setBizAiLawyerWritingTemplateDialoguesRecordId(save.getId());
        bizAiLawyerWritingTemplateDataEntity.setBizAiLawyerWritingTemplateCode(templateCode);
        bizAiLawyerWritingTemplateDataService.save(bizAiLawyerWritingTemplateDataEntity);

        TemplateCallDto templateCallDto = new TemplateCallDto();

        templateCallDto.setBizAiLawyerWritingTemplateDialoguesRecordId(save.getId());
        templateCallDto.setLegalTemplateDto(legalTemplateDto);

        return templateCallDto;
    }

//    private LegalTemplateDto coverUtils(String templateCode, LegalTemplateDto legalTemplateDto, LegalTemplateDto legalTemplateDto) throws IOException {
//
//        BeanUtil.copyProperties(legalTemplateDto,oldLegalTemplateDto,CopyOptions.create().ignoreNullValue());
//        return oldLegalTemplateDto;
//    }


    private List<Message> buildMessages(String dialogsId, Long userId, String input, String fileUrl, List<KnowledgeContentResult> knowledgeContentResults, ToolFunction toolFunction) throws Exception {
        // 获取对话提示词
        String promptCode = "AILawyerWritingPrompt";
        BizAgentApplicationGcConfigEntity documentDialoguePrompt = bizAgentApplicationGcConfigService.getByConfigCode(promptCode);
        if (documentDialoguePrompt == null || StringUtils.isBlank(documentDialoguePrompt.getConfigSystem())) {
            logger.error("获取对话提示词失败 , configCode:{}", promptCode);
            throw new BusinessException("获取对话提示词失败");
        }

        // 加载文件
        String fileContent = StringUtils.EMPTY;
        if (StringUtils.isNoneBlank(fileUrl)) {
            File file = DocumentLoad.downloadURLDocument(fileUrl);
            fileContent = DocumentLoad.documentToText(file);
        }

        // 加载对话提示词
        String prompt = documentDialoguePrompt.getConfigSystem();
        if (CollectionUtils.isNotEmpty(knowledgeContentResults)) {
            String knowledgeContent = JsonUtils.serialize(knowledgeContentResults);
            prompt = prompt.replace("${knowledgeContent}", knowledgeContent);
        } else {
            prompt = prompt.replace("${knowledgeContent}", StringUtils.EMPTY);
        }
        if (toolFunction != null) {
            prompt = prompt.replace("${toolFunction}", JsonUtils.serialize(toolFunction));
        }

        prompt = prompt.replace("${question}", input).replace("${fileContent}", fileContent);

        // 配置message
        List<Message> messages = new ArrayList<>();
        Message systemMessage = new Message();
        systemMessage.setContent(prompt);
        systemMessage.setRole(LLMRoleEnum.SYSTEM.getRole());
        messages.add(systemMessage);

        // 对话记录
        BizAgentApplicationDialoguesRecordEntity recordEntity = new BizAgentApplicationDialoguesRecordEntity();
        recordEntity.setDialogsId(dialogsId);
        recordEntity.setIsDeleted(CommonConstant.IsDeleted.N);
        recordEntity.setMemberId(userId);
        List<BizAgentApplicationDialoguesRecordEntity> recordEntities = bizAgentApplicationDialoguesRecordService.findByExample(recordEntity, null);
        if (CollectionUtils.isNotEmpty(recordEntities)) {
            for (BizAgentApplicationDialoguesRecordEntity entity : recordEntities) {
                Message message = new Message();
                message.setContent(entity.getContent());
                message.setRole(entity.getRole());
                messages.add(message);
            }
        }
        //判断最后是否为User，若是则删除。
        if (CollectionUtils.isNotEmpty(messages)) {
            if (LLMRoleEnum.USER.getRole().equals(messages.get(messages.size() - 1).getRole())) {
                Long recordId = recordEntities.get(recordEntities.size() - 1).getId();
                bizAgentApplicationDialoguesRecordService.deletedById(recordId);
                messages.remove(messages.size() - 1);
            }
        }

        // 用户输入
        Message message = new Message();
        message.setContent(input);
        message.setRole(LLMRoleEnum.USER.getRole());
        messages.add(message);
        logger.info("--------- Build Messages dialogsId:{},messages:{}--------------", dialogsId, messages);
        return messages;
    }


//    private List<KnowledgeContentResult> knowledge(List<Integer> kdIds, String input, Integer topK, Double score, KnowledgeSearchTypeEnum searchTypeEnum) {
//        List<KnowledgeContentResult> knowledgeContentResults = new ArrayList<>();
//        if (CollectionUtils.isEmpty(kdIds)) {
//            return knowledgeContentResults;
//        }
//        List<String> knowledgeIds = new ArrayList<>();
//        for (Integer kdId : kdIds) {
//            BizKnowledgeDocumentEntity knowledgeDocumentEntity = bizKnowledgeDocumentService.get(kdId);
//            // 筛选训练完成的文档，否则跳过该文档
//            if (null == knowledgeDocumentEntity && KnowledgeConstant.TrainStatus.COMPLETE.equals(knowledgeDocumentEntity.getTrainStatus())) {
//                continue;
//            }
//            knowledgeIds.add(knowledgeDocumentEntity.getKnowledgeId());
//        }
//
//        SearchKnowledgeResult searchKnowledgeResult = demandKnowledgeService.searchKnowledge(input, knowledgeIds, topK, score, searchTypeEnum);
//
//        if (CollectionUtils.isNotEmpty(searchKnowledgeResult.getDocuments())) {
//            for (int i = 1; i <= searchKnowledgeResult.getDocuments().size(); i++) {
//                KnowledgeContentResult knowledgeContentResult = new KnowledgeContentResult();
//                knowledgeContentResult.setContent(searchKnowledgeResult.getDocuments().get(i - 1));
//                knowledgeContentResult.setKnowledgeId(searchKnowledgeResult.getKnowledgeIds().get(i - 1));
//                knowledgeContentResult.setScore(searchKnowledgeResult.getScore().get(i - 1));
//                knowledgeContentResults.add(knowledgeContentResult);
//            }
//            // 根据knowledgeId获取知识库名和文档名
//            knowledgeIds = knowledgeContentResults.stream().map(KnowledgeContentResult::getKnowledgeId).distinct().collect(Collectors.toList());
//            List<KnowledgeDocumentRelationQueryItem> knowledgeDocumentRelationQueryItems = bizKnowledgeDocumentService.knowledgeDocumentRelationQuery(knowledgeIds, null);
//            for (KnowledgeContentResult result : knowledgeContentResults) {
//                String knowledgeId = result.getKnowledgeId();
//                KnowledgeDocumentRelationQueryItem item = knowledgeDocumentRelationQueryItems.stream().filter(v -> v.getKnowledgeId().equals(knowledgeId)).findFirst().get();
//                result.setKnowledgeName(item.getKnowledgeName());
//                result.setKdId(item.getKdId());
//                result.setDocumentName(item.getDocumentName());
//            }
//        }
//
//        return knowledgeContentResults;
//    }

    /**
     * 文本输出结果
     *
     * @param sseUtil
     * @param bufferedReader
     * @throws IOException
     */
    private LongtextDialoguesResult textOutputStream(SSEUtil sseUtil, BufferedReader bufferedReader) throws IOException {
        String res = "";
        StringBuilder output = new StringBuilder();
        StringBuilder reasoningContent = new StringBuilder();
        try {
            while ((res = bufferedReader.readLine()) != null) {
                if (StringUtils.isEmpty(res)) {
                    continue;
                }
                res = StringUtils.replace(res, "data: ", StringUtils.EMPTY);
                LargeModelDemandResult result = JsonUtils.deSerialize(res, LargeModelDemandResult.class);
                if (!"0".equals(result.getCode())) {
                    logger.error("LLM Error,code:{}", result.getCode());
                    BusinessException ex = new BusinessException("exception/call.failure");
                    result.setMessage(ex.getMessage());
                    sseUtil.send(JsonUtils.serialize(result));
                    sseUtil.send("[DONE]");
                    sseUtil.complete();
                    throw ex;
                }
                result.setFunction(null);
                result.setDbChainResult(null);
                result.setKnowledgeContentResult(null);
                sseUtil.send(JsonUtils.serialize(result));
                if (StringUtils.isNotEmpty(result.getMessage())) {
                    output.append(result.getMessage());
                }
                if (StringUtils.isNotEmpty(result.getReasoningContent())) {
                    reasoningContent.append(result.getReasoningContent());
                }
            }
            // 关闭资源
            sseUtil.send("[DONE]");
            sseUtil.complete();
            LongtextDialoguesResult longtextDialoguesResult = new LongtextDialoguesResult();
            longtextDialoguesResult.setMessage(output.toString());
            longtextDialoguesResult.setReasoningContent(reasoningContent.toString());
            return longtextDialoguesResult;
        } catch (IOException e) {
            logger.error("连接断开,code:{}", e.getMessage());
            sseUtil.completeByError("连接断开");
            throw new BusinessException("连接断开");
        } finally {
            bufferedReader.close();
            sseUtil.complete();
        }
    }

    public AiWritingTitleGenerationDto titleGeneration(String input) {
        String system = "## 角色\n" +
                "你的任务需要帮我判断用户是否需要进行【写作】\n" +
                "\n" +
                "## 输出\n" +
                "1.包含字段有  needWriting:bool    判断是否需要写作  true-需要 false-不需要 。 title-写作标题，如果需要则生成文章的标题\n" +
                "2.仅使用文本方式输出内容。\n" +
                "\n" +
                "## 输出案例\n" +
                "{”needWriting“:true,\"title\":\"论人工智能发展对生产力的影响\"}";

        // 配置message
        List<Message> messages = new ArrayList<>();
        Message systemMessage = new Message();
        systemMessage.setContent(system);
        systemMessage.setRole(LLMRoleEnum.SYSTEM.getRole());
        messages.add(systemMessage);

        Message userMessage = new Message();
        userMessage.setContent(input);
        userMessage.setRole(LLMRoleEnum.USER.getRole());
        messages.add(userMessage);

        LargeModelResponse largeModelResponse = new LargeModelResponse();
        largeModelResponse.setModel("deepseek-v3");
        largeModelResponse.setMessages(messages.toArray(new Message[0]));
        largeModelResponse.setTopP(0.7F);
        largeModelResponse.setTemperature(0.5F);
        largeModelResponse.setStream(false);
        LargeModelDemandResult largeModelDemandResult = llmService.chat(largeModelResponse);
        if (largeModelDemandResult == null || StringUtils.isBlank(largeModelDemandResult.getMessage())) {
            throw new BusinessException("调用大模型失败");
        }

        String message = largeModelDemandResult.getMessage();
        int startEnd = message.indexOf("{");
        int endIndex = message.lastIndexOf("}");
        if (startEnd == -1 || endIndex == -1) {
            logger.error("解析内容失败, message:{}", message);
            throw new BusinessException("解析内容失败");
        }
        String substring = message.substring(startEnd, endIndex + 1);
        AiWritingTitleGenerationDto aiWritingTitleGenerationDto = JsonUtils.deSerialize(substring, AiWritingTitleGenerationDto.class);
        if (aiWritingTitleGenerationDto == null) {
            aiWritingTitleGenerationDto.setNeedWriting(false);
            aiWritingTitleGenerationDto.setTitle(StringUtils.EMPTY);
        }
        return aiWritingTitleGenerationDto;
    }

}
