package cn.com.poc.law.service.impl;

import cn.com.poc.common.utils.JsonUtils;
import cn.com.poc.common.utils.StringUtils;
import cn.com.poc.law.dto.LegalTemplateDto;

import cn.com.poc.ai_dialogues.entity.BizAiDialoguesEntity;
import cn.com.poc.ai_dialogues.service.BizAiDialoguesService;
import cn.com.poc.common.constant.CommonConstant;
import cn.com.poc.law.dto.TemplateCallDto;
import cn.com.poc.law.dto.TemplateDataDetailDto;
import cn.com.poc.law.entity.motorVehicleDrivingComplaint.MotorVehicleDrivingComplaintEntity;
import cn.com.poc.law.extractEntityStrategy.ExtractEntityStrategy;
import cn.com.poc.law.extractEntityStrategy.LawyerExtractTypeConstants;
import cn.com.poc.law.extractEntityStrategy.LawyerTemplateExtractServiceBuilder;
import cn.com.yict.framemax.core.exception.BusinessException;
import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.poc.law.service.BizAiLawyerWritingTemplateDataService;
import cn.com.poc.law.model.BizAiLawyerWritingTemplateDataModel;
import cn.com.poc.law.entity.BizAiLawyerWritingTemplateDataEntity;
import cn.com.poc.law.convert.BizAiLawyerWritingTemplateDataConvert;
import cn.com.poc.law.repository.BizAiLawyerWritingTemplateDataRepository;
import cn.com.yict.framemax.core.utils.JSON;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.springframework.stereotype.Service;

import org.apache.commons.collections4.CollectionUtils;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.List;
import javax.annotation.Resource;

import org.springframework.util.Assert;

@Service
public class BizAiLawyerWritingTemplateDataServiceImpl extends BaseServiceImpl
        implements BizAiLawyerWritingTemplateDataService {

    @Resource
    private BizAiLawyerWritingTemplateDataRepository repository;

    @Resource
    private BizAiDialoguesService bizAiDialoguesService;
    @Resource
    LawyerTemplateExtractServiceBuilder LawyerTemplateExtractServiceBuilder;

    public BizAiLawyerWritingTemplateDataEntity get(java.lang.Integer id) throws Exception {
        Assert.notNull(id);
        BizAiLawyerWritingTemplateDataModel model = this.repository.get(id);
        if (model == null) {
            return null;
        }
        if ("Y".equals(model.getIsDeleted())) {
            return null;
        }
        return BizAiLawyerWritingTemplateDataConvert.modelToEntity(model);
    }


    public List<BizAiLawyerWritingTemplateDataEntity> findByExample(BizAiLawyerWritingTemplateDataEntity example, PagingInfo pagingInfo) throws Exception {
        List<BizAiLawyerWritingTemplateDataEntity> result = new ArrayList<BizAiLawyerWritingTemplateDataEntity>();
        BizAiLawyerWritingTemplateDataModel model = new BizAiLawyerWritingTemplateDataModel();
        if (example != null) {
            model = BizAiLawyerWritingTemplateDataConvert.entityToModel(example);
        }
        model.setIsDeleted("N");
        List<BizAiLawyerWritingTemplateDataModel> models = this.repository.findByExample(model, pagingInfo);
        if (CollectionUtils.isNotEmpty(models)) {
            result = models.stream().map(BizAiLawyerWritingTemplateDataConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    public BizAiLawyerWritingTemplateDataEntity save(BizAiLawyerWritingTemplateDataEntity entity) throws Exception {
        Assert.notNull(entity);
        entity.setBizAiLawyerWritingTemplateDataId(null);
        entity.setIsDeleted("N");
        BizAiLawyerWritingTemplateDataModel model = BizAiLawyerWritingTemplateDataConvert.entityToModel(entity);
        BizAiLawyerWritingTemplateDataModel saveModel = this.repository.save(model);
        return BizAiLawyerWritingTemplateDataConvert.modelToEntity(saveModel);
    }

    public BizAiLawyerWritingTemplateDataEntity update(BizAiLawyerWritingTemplateDataEntity entity) throws Exception {
        Assert.notNull(entity);
        Assert.notNull(entity.getBizAiLawyerWritingTemplateDataId(), "update pk can not be null");
        BizAiLawyerWritingTemplateDataModel model = this.repository.get(entity.getBizAiLawyerWritingTemplateDataId());

        if (entity.getBizAiLawyerWritingTemplateDialoguesId() != null) {
            model.setBizAiLawyerWritingTemplateDialoguesId(entity.getBizAiLawyerWritingTemplateDialoguesId());
        }
        if (entity.getBizAiLawyerWritingTemplateDialoguesRecordId() != null) {
            model.setBizAiLawyerWritingTemplateDialoguesRecordId(entity.getBizAiLawyerWritingTemplateDialoguesRecordId());
        }
        if (entity.getBizAiLawyerWritingTemplateData() != null) {
            model.setBizAiLawyerWritingTemplateData(entity.getBizAiLawyerWritingTemplateData());
        }
        if (entity.getIsDeleted() != null) {
            model.setIsDeleted(entity.getIsDeleted());
        }
        if (entity.getCreator() != null) {
            model.setCreator(entity.getCreator());
        }
        if (entity.getCreatedTime() != null) {
            model.setCreatedTime(entity.getCreatedTime());
        }
        if (entity.getModifier() != null) {
            model.setModifier(entity.getModifier());
        }
        if (entity.getModifiedTime() != null) {
            model.setModifiedTime(entity.getModifiedTime());
        }
        if (entity.getSysVersion() != null) {
            model.setSysVersion(entity.getSysVersion());
        }
        BizAiLawyerWritingTemplateDataModel saveModel = this.repository.save(model);
        return BizAiLawyerWritingTemplateDataConvert.modelToEntity(saveModel);
    }

    public void deletedById(java.lang.Integer id) throws Exception {
        Assert.notNull(id);
        BizAiLawyerWritingTemplateDataModel model = this.repository.get(id);
        if (model != null) {
            if ("N".equals(model.getIsDeleted())) {
                model.setIsDeleted("Y");
                this.repository.save(model);
            }
        }
    }

    @Override
    public void updateTemplateData(Long recordId, String data) throws Exception {
        Assert.notNull(recordId);
        BizAiLawyerWritingTemplateDataModel model = new BizAiLawyerWritingTemplateDataModel();
        model.setBizAiLawyerWritingTemplateDialoguesRecordId(recordId);
        model.setIsDeleted("N");
        List<BizAiLawyerWritingTemplateDataModel> models = this.repository.findByExample(model, null);
        if (org.springframework.util.CollectionUtils.isEmpty(models)) {
            throw new Exception("找不到该记录");
        }
        BizAiLawyerWritingTemplateDataModel bizAiLawyerWritingTemplateDataModel = models.get(0);
        bizAiLawyerWritingTemplateDataModel.setBizAiLawyerWritingTemplateData(data);
        repository.save(bizAiLawyerWritingTemplateDataModel);
    }

    @Override
    public String downloadTemplateData(Long recordId) throws Exception {
        BizAiLawyerWritingTemplateDataModel model = new BizAiLawyerWritingTemplateDataModel();
        model.setBizAiLawyerWritingTemplateDialoguesRecordId(recordId);
        model.setIsDeleted("N");
        List<BizAiLawyerWritingTemplateDataModel> models = this.repository.findByExample(model, null);
        if (org.springframework.util.CollectionUtils.isEmpty(models)) {
            throw new Exception("找不到该记录");
        }

        ExtractEntityStrategy extractEntityStrategy = LawyerTemplateExtractServiceBuilder.getService(LawyerExtractTypeConstants.LawyerExtractTypeEnum.get(models.get(0).getBizAiLawyerWritingTemplateCode()));
        LegalTemplateDto legalTemplateDto = JsonUtils.deSerialize(models.get(0).getBizAiLawyerWritingTemplateData(), MotorVehicleDrivingComplaintEntity.class);
//        return "https://gsst-poe-sit.gz.bcebos.com/v1/%E6%B0%91%E9%97%B4%E5%80%9F%E8%B4%B7%E7%BA%A0%E7%BA%B7%E6%B0%91%E4%BA%8B%E8%B5%B7%E8%AF%89%E7%8A%B6.docx";
        return extractEntityStrategy.downloadFile(legalTemplateDto);
//        return extractEntityStrategy.downloadFile(JsonUtils.deSerialize(models.get(0).getBizAiLawyerWritingTemplateData(), LegalTemplateDto.class));

    }

    @Override
    public TemplateDataDetailDto getTemplateDataDetail(String dialoguesId, Long userId, boolean ifException) throws Exception {
        BizAiDialoguesEntity bizAiDialoguesEntity = new BizAiDialoguesEntity();
        bizAiDialoguesEntity.setDialoguesId(dialoguesId);
        bizAiDialoguesEntity.setMemberId(userId);
        bizAiDialoguesEntity.setIsDeleted(CommonConstant.IsDeleted.N);
        List<BizAiDialoguesEntity> bizAiDialoguesEntities = bizAiDialoguesService.findByExample(bizAiDialoguesEntity, null);
        if (CollectionUtils.isEmpty(bizAiDialoguesEntities)) {
            throw new BusinessException("当前对话不存在");
        }

        BizAiLawyerWritingTemplateDataEntity example = new BizAiLawyerWritingTemplateDataEntity();
        example.setBizAiLawyerWritingTemplateDialoguesId(dialoguesId);
        example.setIsDeleted(CommonConstant.IsDeleted.N);
        List<BizAiLawyerWritingTemplateDataEntity> bizAiLawyerWritingTemplateDataEntityList = findByExample(example, null);
        if (CollectionUtils.isEmpty(bizAiLawyerWritingTemplateDataEntityList) || StringUtils.isBlank(bizAiLawyerWritingTemplateDataEntityList.get(bizAiLawyerWritingTemplateDataEntityList.size() - 1).getBizAiLawyerWritingTemplateData())) {
            if (ifException) {
                throw new BusinessException("查询不到模板内容信息");
            } else {
                return null;
            }
        }
        BizAiLawyerWritingTemplateDataEntity bizAiLawyerWritingTemplateDataEntity = bizAiLawyerWritingTemplateDataEntityList.get(bizAiLawyerWritingTemplateDataEntityList.size() - 1);
        Type aClass = LawyerExtractTypeConstants.LawyerExtractTypeEnum.getClass(bizAiLawyerWritingTemplateDataEntity.getBizAiLawyerWritingTemplateCode());
        LegalTemplateDto legalTemplateDto = JSON.deSerialize(aClass, bizAiLawyerWritingTemplateDataEntity.getBizAiLawyerWritingTemplateData());
        TemplateDataDetailDto templateDataDetailDto = new TemplateDataDetailDto();
        templateDataDetailDto.setLegalTemplateDto(legalTemplateDto);
        templateDataDetailDto.setRecordId(bizAiLawyerWritingTemplateDataEntity.getBizAiLawyerWritingTemplateDialoguesRecordId());
        return templateDataDetailDto;
    }


}