package cn.com.poc.law.service.impl;	

import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.poc.law.service.BizAiLawyerWritingTemplateDownloadService;
import cn.com.poc.law.model.BizAiLawyerWritingTemplateDownloadModel;
import cn.com.poc.law.entity.BizAiLawyerWritingTemplateDownloadEntity;
import cn.com.poc.law.convert.BizAiLawyerWritingTemplateDownloadConvert;
import cn.com.poc.law.repository.BizAiLawyerWritingTemplateDownloadRepository;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.springframework.stereotype.Service;

import org.apache.commons.collections4.CollectionUtils;
import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.util.Assert;

@Service
public class BizAiLawyerWritingTemplateDownloadServiceImpl extends BaseServiceImpl
 			 implements BizAiLawyerWritingTemplateDownloadService {
   
   @Resource
   private BizAiLawyerWritingTemplateDownloadRepository repository;
    			 
   public BizAiLawyerWritingTemplateDownloadEntity get(java.lang.Long id) throws Exception{
        Assert.notNull(id);
        BizAiLawyerWritingTemplateDownloadModel model =  this.repository.get(id);
        if (model == null){
            return null;
        }
        return BizAiLawyerWritingTemplateDownloadConvert.modelToEntity(model);
   }

       
   public List<BizAiLawyerWritingTemplateDownloadEntity> findByExample(BizAiLawyerWritingTemplateDownloadEntity example,PagingInfo pagingInfo) throws Exception{
        List<BizAiLawyerWritingTemplateDownloadEntity> result = new  ArrayList<BizAiLawyerWritingTemplateDownloadEntity>();
        BizAiLawyerWritingTemplateDownloadModel model = new BizAiLawyerWritingTemplateDownloadModel();
        if (example != null){
            model = BizAiLawyerWritingTemplateDownloadConvert.entityToModel(example);
        }
        List<BizAiLawyerWritingTemplateDownloadModel> models = this.repository.findByExample(model,pagingInfo);
        if (CollectionUtils.isNotEmpty(models)) {
            result = models.stream().map(BizAiLawyerWritingTemplateDownloadConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    public BizAiLawyerWritingTemplateDownloadEntity save(BizAiLawyerWritingTemplateDownloadEntity entity) throws Exception{
        Assert.notNull(entity);
        entity.setId(null);
        BizAiLawyerWritingTemplateDownloadModel model = BizAiLawyerWritingTemplateDownloadConvert.entityToModel(entity);
        BizAiLawyerWritingTemplateDownloadModel saveModel =  this.repository.save(model);
        return BizAiLawyerWritingTemplateDownloadConvert.modelToEntity(saveModel);
    }

    public BizAiLawyerWritingTemplateDownloadEntity update(BizAiLawyerWritingTemplateDownloadEntity entity) throws Exception{
        Assert.notNull(entity);
        Assert.notNull(entity.getId(),"update pk can not be null");
        BizAiLawyerWritingTemplateDownloadModel model = this.repository.get(entity.getId());

       if (entity.getTemplateCode() != null){
        model.setTemplateCode(entity.getTemplateCode());
       }
       if (entity.getType() != null){
        model.setType(entity.getType());
       }
       if (entity.getName() != null){
        model.setName(entity.getName());
       }
       if (entity.getOption() != null){
        model.setOption(entity.getOption());
       }
       if (entity.getEntityClass() != null){
        model.setEntityClass(entity.getEntityClass());
       }
        BizAiLawyerWritingTemplateDownloadModel saveModel =  this.repository.save(model);
        return BizAiLawyerWritingTemplateDownloadConvert.modelToEntity(saveModel);
    }

    public void deletedById(java.lang.Long id) throws Exception{
        Assert.notNull(id);
        BizAiLawyerWritingTemplateDownloadModel model =  this.repository.get(id);
        if (model != null){
       }
   }
    
}