package cn.com.poc.law.service.impl;	

import cn.com.poc.law.constant.LawyerWritingTemplateTypeConstants;
import cn.com.poc.law.dto.BizAiLawyerWritingTemplateDto;
import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.poc.law.service.BizAiLawyerWritingTemplateService;
import cn.com.poc.law.model.BizAiLawyerWritingTemplateModel;
import cn.com.poc.law.entity.BizAiLawyerWritingTemplateEntity;
import cn.com.poc.law.convert.BizAiLawyerWritingTemplateConvert;
import cn.com.poc.law.repository.BizAiLawyerWritingTemplateRepository;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.springframework.stereotype.Service;

import org.apache.commons.collections4.CollectionUtils;
import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.util.Assert;

@Service
public class BizAiLawyerWritingTemplateServiceImpl extends BaseServiceImpl
 			 implements BizAiLawyerWritingTemplateService {
   
   @Resource
   private BizAiLawyerWritingTemplateRepository repository;
    			 
   public BizAiLawyerWritingTemplateEntity get(java.lang.Integer id) throws Exception{
        Assert.notNull(id);
        BizAiLawyerWritingTemplateModel model =  this.repository.get(id);
        if (model == null){
            return null;
        }
        return BizAiLawyerWritingTemplateConvert.modelToEntity(model);
   }


   public List<BizAiLawyerWritingTemplateEntity> findByExample(BizAiLawyerWritingTemplateEntity example,PagingInfo pagingInfo) throws Exception{
        List<BizAiLawyerWritingTemplateEntity> result = new  ArrayList<BizAiLawyerWritingTemplateEntity>();
        BizAiLawyerWritingTemplateModel model = new BizAiLawyerWritingTemplateModel();
        if (example != null){
            model = BizAiLawyerWritingTemplateConvert.entityToModel(example);
        }
        List<BizAiLawyerWritingTemplateModel> models = this.repository.findByExample(model,pagingInfo);
        if (CollectionUtils.isNotEmpty(models)) {
            result = models.stream().map(BizAiLawyerWritingTemplateConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    public BizAiLawyerWritingTemplateEntity save(BizAiLawyerWritingTemplateEntity entity) throws Exception{
        Assert.notNull(entity);
        entity.setLawyerWritingTemplateId(null);
        BizAiLawyerWritingTemplateModel model = BizAiLawyerWritingTemplateConvert.entityToModel(entity);
        BizAiLawyerWritingTemplateModel saveModel =  this.repository.save(model);
        return BizAiLawyerWritingTemplateConvert.modelToEntity(saveModel);
    }

    public BizAiLawyerWritingTemplateEntity update(BizAiLawyerWritingTemplateEntity entity) throws Exception{
        Assert.notNull(entity);
        Assert.notNull(entity.getLawyerWritingTemplateId(),"update pk can not be null");
        BizAiLawyerWritingTemplateModel model = this.repository.get(entity.getLawyerWritingTemplateId());

       if (entity.getLawyerWritingTemplateType() != null){
        model.setLawyerWritingTemplateType(entity.getLawyerWritingTemplateType());
       }
       if (entity.getLawyerWritingTemplateIcon() != null){
        model.setLawyerWritingTemplateIcon(entity.getLawyerWritingTemplateIcon());
       }
       if (entity.getLawyerWritingTemplateName() != null){
        model.setLawyerWritingTemplateName(entity.getLawyerWritingTemplateName());
       }
       if (entity.getLawyerWritingTemplateDesc() != null){
        model.setLawyerWritingTemplateDesc(entity.getLawyerWritingTemplateDesc());
       }
       if (entity.getLawyerWritingTemplateCode() != null){
        model.setLawyerWritingTemplateCode(entity.getLawyerWritingTemplateCode());
       }
       if (entity.getLawyerWritingTemplateClassification() != null){
        model.setLawyerWritingTemplateClassification(entity.getLawyerWritingTemplateClassification());
       }
        BizAiLawyerWritingTemplateModel saveModel =  this.repository.save(model);
        return BizAiLawyerWritingTemplateConvert.modelToEntity(saveModel);
    }


    @Override
    public List<BizAiLawyerWritingTemplateEntity> getByType(String templateType) throws Exception {
        BizAiLawyerWritingTemplateEntity example = new BizAiLawyerWritingTemplateEntity();
        example.setLawyerWritingTemplateType(templateType);
        List<BizAiLawyerWritingTemplateEntity> bizAiLawyerWritingTemplateEntityList = findByExample(example,null);
        return bizAiLawyerWritingTemplateEntityList;
    }

    @Override
    public List<BizAiLawyerWritingTemplateEntity> getTemplateWritingList() throws Exception {
        BizAiLawyerWritingTemplateEntity example = new BizAiLawyerWritingTemplateEntity();
        example.setLawyerWritingTemplateClassification(LawyerWritingTemplateTypeConstants.LawyerWritingTemplateClassification.template);
        List<BizAiLawyerWritingTemplateEntity> bizAiLawyerWritingTemplateEntityList = findByExample(example,null);
        return bizAiLawyerWritingTemplateEntityList;
    }

}