package cn.com.poc.law.service.impl;	

import cn.com.poc.law.query.LawyerWritingTemplateTypeQueryCondition;
import cn.com.poc.law.query.LawyerWritingTemplateTypeQueryItem;
import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.poc.law.service.BizAiLawyerWritingTemplateTypeService;
import cn.com.poc.law.model.BizAiLawyerWritingTemplateTypeModel;
import cn.com.poc.law.entity.BizAiLawyerWritingTemplateTypeEntity;
import cn.com.poc.law.convert.BizAiLawyerWritingTemplateTypeConvert;
import cn.com.poc.law.repository.BizAiLawyerWritingTemplateTypeRepository;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.springframework.stereotype.Service;

import org.apache.commons.collections4.CollectionUtils;
import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.util.Assert;

@Service
public class BizAiLawyerWritingTemplateTypeServiceImpl extends BaseServiceImpl
 			 implements BizAiLawyerWritingTemplateTypeService {
   
   @Resource
   private BizAiLawyerWritingTemplateTypeRepository repository;
    			 
   public BizAiLawyerWritingTemplateTypeEntity get(java.lang.Integer id) throws Exception{
        Assert.notNull(id);
        BizAiLawyerWritingTemplateTypeModel model =  this.repository.get(id);
        if (model == null){
            return null;
        }
        return BizAiLawyerWritingTemplateTypeConvert.modelToEntity(model);
   }

       
   public List<BizAiLawyerWritingTemplateTypeEntity> findByExample(BizAiLawyerWritingTemplateTypeEntity example,PagingInfo pagingInfo) throws Exception{
        List<BizAiLawyerWritingTemplateTypeEntity> result = new  ArrayList<BizAiLawyerWritingTemplateTypeEntity>();
        BizAiLawyerWritingTemplateTypeModel model = new BizAiLawyerWritingTemplateTypeModel();
        if (example != null){
            model = BizAiLawyerWritingTemplateTypeConvert.entityToModel(example);
        }
        List<BizAiLawyerWritingTemplateTypeModel> models = this.repository.findByExample(model,pagingInfo);
        if (CollectionUtils.isNotEmpty(models)) {
            result = models.stream().map(BizAiLawyerWritingTemplateTypeConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    public BizAiLawyerWritingTemplateTypeEntity save(BizAiLawyerWritingTemplateTypeEntity entity) throws Exception{
        Assert.notNull(entity);
        entity.setLawyerWritingTemplateId(null);
        BizAiLawyerWritingTemplateTypeModel model = BizAiLawyerWritingTemplateTypeConvert.entityToModel(entity);
        BizAiLawyerWritingTemplateTypeModel saveModel =  this.repository.save(model);
        return BizAiLawyerWritingTemplateTypeConvert.modelToEntity(saveModel);
    }

    public BizAiLawyerWritingTemplateTypeEntity update(BizAiLawyerWritingTemplateTypeEntity entity) throws Exception{
        Assert.notNull(entity);
        Assert.notNull(entity.getLawyerWritingTemplateId(),"update pk can not be null");
        BizAiLawyerWritingTemplateTypeModel model = this.repository.get(entity.getLawyerWritingTemplateId());

       if (entity.getLawyerWritingTemplateType() != null){
        model.setLawyerWritingTemplateType(entity.getLawyerWritingTemplateType());
       }
       if (entity.getLawyerWritingTemplateName() != null){
        model.setLawyerWritingTemplateName(entity.getLawyerWritingTemplateName());
       }
        BizAiLawyerWritingTemplateTypeModel saveModel =  this.repository.save(model);
        return BizAiLawyerWritingTemplateTypeConvert.modelToEntity(saveModel);
    }

    public void deletedById(java.lang.Integer id) throws Exception{
        Assert.notNull(id);
        BizAiLawyerWritingTemplateTypeModel model =  this.repository.get(id);
        if (model != null){
       }
   }

    @Override
    public List<LawyerWritingTemplateTypeQueryItem> queryLawyerWritingTemplateType(LawyerWritingTemplateTypeQueryCondition condition, PagingInfo pagingInfo) throws Exception {
        return this.sqlDao.query(condition, LawyerWritingTemplateTypeQueryItem.class, pagingInfo);
    }
    
}