package cn.com.poc.long_document.model;

import cn.com.yict.framemax.data.model.BaseModelClass;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.io.Serializable;

/**
 * Model class for biz_long_text_dialogues_record
 * 长文文档-用户对话记录
 */
@Entity
@Table(name = "biz_long_text_dialogues_record")
@DynamicInsert
@DynamicUpdate
public class BizLongTextDialoguesRecordModel extends BaseModelClass implements Serializable {

    private static final long serialVersionUID = 1L;


    /**
     * id
     * 主键ID
     */
    private Long id;

    @Column(name = "id", length = 19)
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
        super.addValidField("id");
    }


    /**
     * role
     * 角色 user-用户  assistant-助手
     */
    private String role;

    @Column(name = "role", length = 100)
    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
        super.addValidField("role");
    }


    /**
     * dialogs_id
     * 会话ID
     */
    private String dialogsId;

    @Column(name = "dialogs_id", length = 100)
    public String getDialogsId() {
        return this.dialogsId;
    }

    public void setDialogsId(String dialogsId) {
        this.dialogsId = dialogsId;
        super.addValidField("dialogsId");
    }


    /**
     * member_id
     * 用户ID
     */
    private Long memberId;

    @Column(name = "member_id", length = 19)
    public Long getMemberId() {
        return this.memberId;
    }

    public void setMemberId(Long memberId) {
        this.memberId = memberId;
        super.addValidField("memberId");
    }


    /**
     * content
     * 内容
     */
    private String content;

    @Column(name = "content", length = 2147483647)
    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
        super.addValidField("content");
    }


    /**
     * reasoning_content
     * 推理内容
     */
    private String reasoningContent;

    @Column(name = "reasoning_content", length = 2147483647)
    public String getReasoningContent() {
        return this.reasoningContent;
    }

    public void setReasoningContent(String reasoningContent) {
        this.reasoningContent = reasoningContent;
        super.addValidField("reasoningContent");
    }

    /**
     * fileUrl
     * 文件
     */
    private String fileUrl;

    @Column(name = "file_url", length = 150)
    public String getFileUrl() {
        return this.fileUrl;
    }

    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
        super.addValidField("fileUrl");
    }


    /**
     * timestamp
     * 时间戳
     */
    private Long timestamp;

    @Column(name = "timestamp", length = 19)
    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
        super.addValidField("timestamp");
    }


    /**
     * is_deleted
     * 是否删除 1、Y 是 2、N 否
     */
    private String isDeleted;

    @Column(name = "is_deleted", length = 1)
    public String getIsDeleted() {
        return this.isDeleted;
    }

    public void setIsDeleted(String isDeleted) {
        this.isDeleted = isDeleted;
        super.addValidField("isDeleted");
    }


    /**
     * CREATOR
     * 创建人
     */
    private String creator;

    @Column(name = "CREATOR", length = 225)
    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
        super.addValidField("creator");
    }


    /**
     * CREATED_TIME
     * 创建时间
     */
    private java.util.Date createdTime;

    @Column(name = "CREATED_TIME", length = 19)
    public java.util.Date getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(java.util.Date createdTime) {
        this.createdTime = createdTime;
        super.addValidField("createdTime");
    }


    /**
     * MODIFIER
     * 修改人
     */
    private String modifier;

    @Column(name = "MODIFIER", length = 225)
    public String getModifier() {
        return this.modifier;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
        super.addValidField("modifier");
    }


    /**
     * MODIFIED_TIME
     * 修改时间
     */
    private java.util.Date modifiedTime;

    @Column(name = "MODIFIED_TIME", length = 19)
    public java.util.Date getModifiedTime() {
        return this.modifiedTime;
    }

    public void setModifiedTime(java.util.Date modifiedTime) {
        this.modifiedTime = modifiedTime;
        super.addValidField("modifiedTime");
    }


    /**
     * SYS_VERSION
     * 乐观锁,版本号
     */
    private Integer sysVersion;

    @Column(name = "SYS_VERSION", length = 10)
    @Version
    public Integer getSysVersion() {
        return this.sysVersion;
    }

    public void setSysVersion(Integer sysVersion) {
        this.sysVersion = sysVersion;
        super.addValidField("sysVersion");
    }


}