package cn.com.poc.long_document.rest.impl;


import cn.com.poc.common.utils.Assert;
import cn.com.poc.common.utils.BlContext;
import cn.com.poc.long_document.aggregate.LongTextDialoguesService;
import cn.com.poc.long_document.dto.LongTextDialoguesCallDto;
import cn.com.poc.long_document.dto.LongTextExampleDto;
import cn.com.poc.long_document.dto.LongTextSummaryDto;
import cn.com.poc.long_document.rest.LongTextDialoguesRest;
import cn.com.poc.support.security.oauth.entity.UserBaseEntity;
import cn.com.yict.framemax.core.exception.BusinessException;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;


/**
 * @author alex.yao
 * @date 2025/6/3
 */
@Component
public class LongTextDialoguesRestImpl implements LongTextDialoguesRest {

    @Resource
    private LongTextDialoguesService longTextDialoguesService;

    @Override
    public void call(LongTextDialoguesCallDto dto) throws Exception {
        Assert.notBlank(dto.getDialoguesId(), "对话ID不能为空");
        Assert.notBlank(dto.getInput(), "输入内容不能为空");

        UserBaseEntity userBaseEntity = BlContext.getCurrentUserNotException();
        if (userBaseEntity == null) {
            throw new BusinessException("用户未登录");
        }

        longTextDialoguesService.call(dto.getDialoguesId(),
                dto.getFileUrl(),
                dto.getInput(),
                dto.getKnowledgeIds(),
                userBaseEntity.getUserId(), dto.getEnableSearchEngine(), dto.getEnableDeepThinking());
    }

    @Override
    public LongTextSummaryDto summary(String dialoguesId) throws Exception {
        UserBaseEntity userBaseEntity = BlContext.getCurrentUserNotException();
        if (userBaseEntity == null) {
            throw new BusinessException("用户未登录");
        }
        return longTextDialoguesService.summary(dialoguesId, userBaseEntity.getUserId());
    }

    @Override
    public List<LongTextExampleDto> example() throws Exception {
        return longTextDialoguesService.example();
    }
}
