package cn.com.poc.long_document.service.impl;

import cn.com.poc.long_document.model.BizLongTextDialoguesModel;
import cn.com.poc.long_document.repository.BizLongTextDialoguesRepository;
import cn.com.poc.long_document.service.BizLongTextDialoguesService;
import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Collection;
import java.util.List;

@Service
public class BizLongTextDialoguesServiceImpl extends BaseServiceImpl
        implements BizLongTextDialoguesService {

    @Resource
    private BizLongTextDialoguesRepository repository;

    public BizLongTextDialoguesModel get(Long id) throws Exception {
        return this.repository.get(id);
    }

    public List<BizLongTextDialoguesModel> findByExample(BizLongTextDialoguesModel example, PagingInfo pagingInfo) throws Exception {
        if (example == null) {
            example = new BizLongTextDialoguesModel();
        }
        return this.repository.findByExample(example, "id desc", pagingInfo);
    }

    public void delete(BizLongTextDialoguesModel model) throws Exception {
        this.repository.remove(model);
    }

    public void deleteById(Long id) throws Exception {
        this.repository.removeByPk(id);
    }

    public void deleteAll(Collection<Long> ids) throws Exception {
        this.repository.removeAllByPk(ids);
    }

    public BizLongTextDialoguesModel save(BizLongTextDialoguesModel model) throws Exception {
        return this.repository.save(model);
    }

    public Collection<BizLongTextDialoguesModel> saveAll(Collection<BizLongTextDialoguesModel> models) throws Exception {
        return this.repository.saveAll(models);
    }
}