package cn.com.poc.long_document.service.impl;

import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.poc.long_document.service.BizLongTextSummaryCacheService;
import cn.com.poc.long_document.model.BizLongTextSummaryCacheModel;
import cn.com.poc.long_document.entity.BizLongTextSummaryCacheEntity;
import cn.com.poc.long_document.convert.BizLongTextSummaryCacheConvert;
import cn.com.poc.long_document.repository.BizLongTextSummaryCacheRepository;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.springframework.stereotype.Service;

import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.List;
import javax.annotation.Resource;

import org.springframework.util.Assert;

@Service
public class BizLongTextSummaryCacheServiceImpl extends BaseServiceImpl
        implements BizLongTextSummaryCacheService {

    @Resource
    private BizLongTextSummaryCacheRepository repository;

    public BizLongTextSummaryCacheEntity get(java.lang.Long id) throws Exception {
        Assert.notNull(id);
        BizLongTextSummaryCacheModel model = this.repository.get(id);
        if (model == null) {
            return null;
        }
        if ("Y".equals(model.getIsDeleted())) {
            return null;
        }
        return BizLongTextSummaryCacheConvert.modelToEntity(model);
    }


    public List<BizLongTextSummaryCacheEntity> findByExample(BizLongTextSummaryCacheEntity example, PagingInfo pagingInfo) throws Exception {
        List<BizLongTextSummaryCacheEntity> result = new ArrayList<BizLongTextSummaryCacheEntity>();
        BizLongTextSummaryCacheModel model = new BizLongTextSummaryCacheModel();
        if (example != null) {
            model = BizLongTextSummaryCacheConvert.entityToModel(example);
        }
        model.setIsDeleted("N");
        List<BizLongTextSummaryCacheModel> models = this.repository.findByExample(model, pagingInfo);
        if (CollectionUtils.isNotEmpty(models)) {
            result = models.stream().map(BizLongTextSummaryCacheConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    public BizLongTextSummaryCacheEntity save(BizLongTextSummaryCacheEntity entity) throws Exception {
        Assert.notNull(entity);
        entity.setId(null);
        entity.setIsDeleted("N");
        BizLongTextSummaryCacheModel model = BizLongTextSummaryCacheConvert.entityToModel(entity);
        BizLongTextSummaryCacheModel saveModel = this.repository.save(model);
        return BizLongTextSummaryCacheConvert.modelToEntity(saveModel);
    }

    public BizLongTextSummaryCacheEntity update(BizLongTextSummaryCacheEntity entity) throws Exception {
        Assert.notNull(entity);
        Assert.notNull(entity.getId(), "update pk can not be null");
        BizLongTextSummaryCacheModel model = this.repository.get(entity.getId());

        if (entity.getCorePoint() != null) {
            model.setCorePoint(entity.getCorePoint());
        }
        if (entity.getSummary() != null) {
            model.setSummary(entity.getSummary());
        }
        if (entity.getFileUrl() != null) {
            model.setFileUrl(entity.getFileUrl());
        }
        if (entity.getMindmap() != null) {
            model.setMindmap(entity.getMindmap());
        }
        if (entity.getKeyword() != null) {
            model.setKeyword(entity.getKeyword());
        }
        if (entity.getFileMd5() != null) {
            model.setFileMd5(entity.getFileMd5());
        }
        if (entity.getIsDeleted() != null) {
            model.setIsDeleted(entity.getIsDeleted());
        }
        if (entity.getCreator() != null) {
            model.setCreator(entity.getCreator());
        }
        if (entity.getCreatedTime() != null) {
            model.setCreatedTime(entity.getCreatedTime());
        }
        if (entity.getModifier() != null) {
            model.setModifier(entity.getModifier());
        }
        if (entity.getModifiedTime() != null) {
            model.setModifiedTime(entity.getModifiedTime());
        }
        if (entity.getSysVersion() != null) {
            model.setSysVersion(entity.getSysVersion());
        }
        BizLongTextSummaryCacheModel saveModel = this.repository.save(model);
        return BizLongTextSummaryCacheConvert.modelToEntity(saveModel);
    }

    public void deletedById(java.lang.Long id) throws Exception {
        Assert.notNull(id);
        BizLongTextSummaryCacheModel model = this.repository.get(id);
        if (model != null) {
            if ("N".equals(model.getIsDeleted())) {
                model.setIsDeleted("Y");
                this.repository.save(model);
            }
        }
    }

}