package cn.com.poc.meeting.aggregate;

import cn.com.poc.meeting.entity.AnalysisTaskDetailEntity;

/**
 * AI会议助手服务
 */
public interface AiMeetingAssistantService {


    /**
     * 创建会议解析任务
     *
     * @param fileUrl     音频文件地址
     * @param dialoguesId 会议ID
     * @param userId      用户ID
     * @return 任务状态
     */
    String createTask(String fileUrl, String dialoguesId, Long userId);


    /**
     * 获取会议解析任务详情
     *
     * @param dialoguesId
     * @param userId
     * @return
     */
    AnalysisTaskDetailEntity getTaskDetail(String dialoguesId, Long userId);


    /**
     * 示例-获取会议解析任务详情
     *
     * @param dialoguesId
     * @return
     */
    AnalysisTaskDetailEntity getExampleTaskDetail(String dialoguesId) throws Exception;

    /**
     * 调用AI助手对话
     *
     * @param dialoguesId
     * @param fileUrl
     * @param input
     * @param knowledgeIds
     * @param userId
     */
    void call(String dialoguesId, String fileUrl, String input, Integer[] knowledgeIds, Long userId) throws Exception;


}
