package cn.com.poc.meeting.analysis;

import cn.com.poc.agent_application.entity.BizAgentApplicationGcConfigEntity;
import cn.com.poc.thirdparty.resource.demand.ai.entity.dialogue.Message;
import cn.com.poc.thirdparty.resource.demand.ai.entity.largemodel.LargeModelDemandResult;
import cn.com.poc.thirdparty.resource.demand.ai.entity.largemodel.LargeModelResponse;
import cn.com.yict.framemax.core.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThemeAnalyzer extends MeetingContentAnalysisAbstract<String> {

    private final Logger logger = LoggerFactory.getLogger(ThemeAnalyzer.class);

    private final String GC_CONFIG_CODE = "MEETING_THEME";

    @Override
    public String run(String content) {
        BizAgentApplicationGcConfigEntity firstGcConfigEntity = bizAgentApplicationGcConfigService.getByConfigCode(GC_CONFIG_CODE);
        if (firstGcConfigEntity == null) {
            throw new BusinessException("无法找到生成会议主题配置");
        }
        // 配置prompt参数
        String prompt = firstGcConfigEntity.getConfigSystem();
        String model = firstGcConfigEntity.getLargeModel();

        // 会议主题生成
        return generateTheme(content, prompt, model);
    }

    private String generateTheme(String content, String prompt, String model) {
        LargeModelResponse largeResponse = new LargeModelResponse();
        largeResponse.setModel(model);
        Message[] messages = new Message[1];

        Message message1 = new Message();
        message1.setContent(prompt.replace("{content}", content));
        message1.setRole("user");
        messages[0] = message1;
        largeResponse.setMessages(messages);
        largeResponse.setStream(false);
        largeResponse.setUser("MEETING_THEME");
        LargeModelDemandResult chatResult = llmService.chat(largeResponse);
        return chatResult.getMessage();
    }

}
