package cn.com.poc.meeting.convert;

import cn.com.poc.common.utils.JsonUtils;
import cn.com.poc.meeting.cache.KeyWordCounter;
import cn.com.poc.meeting.constants.MeetingAssistantConstantEnum;
import cn.com.poc.meeting.entity.AnalysisTaskDetailEntity;
import cn.com.poc.meeting.model.BizMeetingAssistantAnalysisTaskModel;
import cn.com.poc.meeting.entity.BizMeetingAssistantAnalysisTaskEntity;
import cn.com.poc.meeting.dto.BizMeetingAssistantAnalysisTaskDto;
import com.alibaba.fastjson.TypeReference;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;


public class BizMeetingAssistantAnalysisTaskConvert {

    public static BizMeetingAssistantAnalysisTaskEntity modelToEntity(BizMeetingAssistantAnalysisTaskModel model) {
        BizMeetingAssistantAnalysisTaskEntity entity = new BizMeetingAssistantAnalysisTaskEntity();
        entity.setId(model.getId());
        entity.setMemberId(model.getMemberId());
        entity.setDiaguesId(model.getDiaguesId());
        entity.setAnalysisStatus(model.getAnalysisStatus());
        entity.setThemeContent(model.getThemeContent());
        entity.setThemeGenerateStatus(model.getThemeGenerateStatus());
        entity.setKeyWordContent(model.getKeyWordContent());
        entity.setKeyWordGenerateStatus(model.getKeyWordGenerateStatus());
        entity.setMeetingSummaryContent(model.getMeetingSummaryContent());
        entity.setMeetingSummaryGenerateStatus(model.getMeetingSummaryGenerateStatus());
        entity.setFeaturedQuestionsGenerateStatus(model.getFeaturedQuestionsGenerateStatus());
        entity.setFeaturedQuestions(model.getFeaturedQuestions());
        entity.setIsDeleted(model.getIsDeleted());
        entity.setCreator(model.getCreator());
        entity.setCreatedTime(model.getCreatedTime());
        entity.setModifier(model.getModifier());
        entity.setModifiedTime(model.getModifiedTime());
        entity.setSysVersion(model.getSysVersion());
        return entity;
    }

    public static BizMeetingAssistantAnalysisTaskModel entityToModel(BizMeetingAssistantAnalysisTaskEntity entity) {
        BizMeetingAssistantAnalysisTaskModel model = new BizMeetingAssistantAnalysisTaskModel();
        model.setId(entity.getId());
        model.setMemberId(entity.getMemberId());
        model.setDiaguesId(entity.getDiaguesId());
        model.setAnalysisStatus(entity.getAnalysisStatus());
        model.setThemeContent(entity.getThemeContent());
        model.setThemeGenerateStatus(entity.getThemeGenerateStatus());
        model.setKeyWordContent(entity.getKeyWordContent());
        model.setKeyWordGenerateStatus(entity.getKeyWordGenerateStatus());
        model.setMeetingSummaryContent(entity.getMeetingSummaryContent());
        model.setMeetingSummaryGenerateStatus(entity.getMeetingSummaryGenerateStatus());
        model.setFeaturedQuestionsGenerateStatus(entity.getFeaturedQuestionsGenerateStatus());
        model.setFeaturedQuestions(entity.getFeaturedQuestions());
        model.setIsDeleted(entity.getIsDeleted());
        model.setCreator(entity.getCreator());
        model.setCreatedTime(entity.getCreatedTime());
        model.setModifier(entity.getModifier());
        model.setModifiedTime(entity.getModifiedTime());
        model.setSysVersion(entity.getSysVersion());
        return model;
    }

    public static BizMeetingAssistantAnalysisTaskDto entityToDto(BizMeetingAssistantAnalysisTaskEntity entity) {
        BizMeetingAssistantAnalysisTaskDto dto = new BizMeetingAssistantAnalysisTaskDto();
        dto.setId(entity.getId());
        dto.setMemberId(entity.getMemberId());
        dto.setDiaguesId(entity.getDiaguesId());
        dto.setAnalysisStatus(entity.getAnalysisStatus());
        dto.setThemeContent(entity.getThemeContent());
        dto.setThemeGenerateStatus(entity.getThemeGenerateStatus());
        dto.setKeyWordContent(entity.getKeyWordContent());
        dto.setKeyWordGenerateStatus(entity.getKeyWordGenerateStatus());
        dto.setMeetingSummaryContent(entity.getMeetingSummaryContent());
        dto.setMeetingSummaryGenerateStatus(entity.getMeetingSummaryGenerateStatus());
        dto.setFeaturedQuestionsGenerateStatus(entity.getFeaturedQuestionsGenerateStatus());
        dto.setFeaturedQuestions(entity.getFeaturedQuestions());
        dto.setIsDeleted(entity.getIsDeleted());
        dto.setCreator(entity.getCreator());
        dto.setCreatedTime(entity.getCreatedTime());
        dto.setModifier(entity.getModifier());
        dto.setModifiedTime(entity.getModifiedTime());
        dto.setSysVersion(entity.getSysVersion());
        return dto;
    }

    public static BizMeetingAssistantAnalysisTaskEntity dtoToEntity(BizMeetingAssistantAnalysisTaskDto dto) {
        BizMeetingAssistantAnalysisTaskEntity entity = new BizMeetingAssistantAnalysisTaskEntity();
        entity.setId(dto.getId());
        entity.setMemberId(dto.getMemberId());
        entity.setDiaguesId(dto.getDiaguesId());
        entity.setAnalysisStatus(dto.getAnalysisStatus());
        entity.setThemeContent(dto.getThemeContent());
        entity.setThemeGenerateStatus(dto.getThemeGenerateStatus());
        entity.setKeyWordContent(dto.getKeyWordContent());
        entity.setKeyWordGenerateStatus(dto.getKeyWordGenerateStatus());
        entity.setMeetingSummaryContent(dto.getMeetingSummaryContent());
        entity.setMeetingSummaryGenerateStatus(dto.getMeetingSummaryGenerateStatus());
        entity.setFeaturedQuestionsGenerateStatus(dto.getFeaturedQuestionsGenerateStatus());
        entity.setFeaturedQuestions(dto.getFeaturedQuestions());
        entity.setIsDeleted(dto.getIsDeleted());
        entity.setCreator(dto.getCreator());
        entity.setCreatedTime(dto.getCreatedTime());
        entity.setModifier(dto.getModifier());
        entity.setModifiedTime(dto.getModifiedTime());
        entity.setSysVersion(dto.getSysVersion());
        return entity;
    }

    public static AnalysisTaskDetailEntity bizEntityToDetailEntity(BizMeetingAssistantAnalysisTaskEntity entity) {
        AnalysisTaskDetailEntity analysisTaskDetailEntity = new AnalysisTaskDetailEntity();
        analysisTaskDetailEntity.setAnalysisStatus(entity.getAnalysisStatus());
        analysisTaskDetailEntity.setThemeContent(entity.getThemeContent());
        analysisTaskDetailEntity.setThemeGenerateStatus(entity.getThemeGenerateStatus());

        analysisTaskDetailEntity.setKeyWordGenerateStatus(entity.getKeyWordGenerateStatus());
        //获取关键字计数
        if (MeetingAssistantConstantEnum.COMPLETED.getStatus().equals(entity.getKeyWordGenerateStatus())) {
            Map<String, Integer> keywordCountMap = KeyWordCounter.getKeywordCountCache(entity.getDiaguesId());
            analysisTaskDetailEntity.setKeyWordCount(keywordCountMap);

            if (StringUtils.isNotBlank(entity.getKeyWordContent())) {
                List<String> keyWords = new ArrayList<>(keywordCountMap.keySet());
                analysisTaskDetailEntity.setKeyWordContent(keyWords);
            }
        }
        analysisTaskDetailEntity.setMeetingSummaryContent(entity.getMeetingSummaryContent());
        analysisTaskDetailEntity.setMeetingSummaryGenerateStatus(entity.getMeetingSummaryGenerateStatus());
        analysisTaskDetailEntity.setFeaturedQuestionsGenerateStatus(entity.getFeaturedQuestionsGenerateStatus());
        if (StringUtils.isNotBlank(entity.getFeaturedQuestions())) {
            List<String> featuredQuestions = JsonUtils.deSerialize(entity.getFeaturedQuestions(), new TypeReference<List<String>>() {
            }.getType());
            analysisTaskDetailEntity.setFeaturedQuestions(featuredQuestions);
        }
        return analysisTaskDetailEntity;

    }
}