package cn.com.poc.meeting.model;	

import java.io.Serializable;
import cn.com.yict.framemax.data.model.BaseModelClass;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Id;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import javax.persistence.Version;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;

/**
 * Model class for biz_meeting_assistant_analysis_task
 * 会议助手-会议内容分析任务表
 */
@Entity
@Table(name = "biz_meeting_assistant_analysis_task")
@DynamicInsert
@DynamicUpdate
public class BizMeetingAssistantAnalysisTaskModel extends BaseModelClass implements Serializable {

    private static final long serialVersionUID = 1L;
    
  
    /** id
    *
    */ 
    private java.lang.Long id;
    
    @Column(name = "id",length = 19)
	@Id @GeneratedValue(strategy = GenerationType.AUTO) 
    public java.lang.Long getId(){
        return this.id;
    }
    
    public void setId(java.lang.Long id){
        this.id = id;
        super.addValidField("id");
    }
    
  
    /** member_id
    *用户id
    */ 
    private java.lang.Long memberId;
    
    @Column(name = "member_id",length = 19)
    public java.lang.Long getMemberId(){
        return this.memberId;
    }
    
    public void setMemberId(java.lang.Long memberId){
        this.memberId = memberId;
        super.addValidField("memberId");
    }
    
  
    /** diagues_id
    *会话id
    */ 
    private java.lang.String diaguesId;
    
    @Column(name = "diagues_id",length = 120)
    public java.lang.String getDiaguesId(){
        return this.diaguesId;
    }
    
    public void setDiaguesId(java.lang.String diaguesId){
        this.diaguesId = diaguesId;
        super.addValidField("diaguesId");
    }
    
  
    /** analysis_status
    *内容分析总状态 generate-生成中 completed-完成 failed-失败
    */ 
    private java.lang.String analysisStatus;
    
    @Column(name = "analysis_status",length = 15)
    public java.lang.String getAnalysisStatus(){
        return this.analysisStatus;
    }
    
    public void setAnalysisStatus(java.lang.String analysisStatus){
        this.analysisStatus = analysisStatus;
        super.addValidField("analysisStatus");
    }
    
  
    /** theme_content
    *会议主题
    */ 
    private java.lang.String themeContent;
    
    @Column(name = "theme_content",length = 2147483647)
    public java.lang.String getThemeContent(){
        return this.themeContent;
    }
    
    public void setThemeContent(java.lang.String themeContent){
        this.themeContent = themeContent;
        super.addValidField("themeContent");
    }
    
  
    /** theme_generate_status
    *会议主题生成状态
    */ 
    private java.lang.String themeGenerateStatus;
    
    @Column(name = "theme_generate_status",length = 15)
    public java.lang.String getThemeGenerateStatus(){
        return this.themeGenerateStatus;
    }
    
    public void setThemeGenerateStatus(java.lang.String themeGenerateStatus){
        this.themeGenerateStatus = themeGenerateStatus;
        super.addValidField("themeGenerateStatus");
    }
    
  
    /** key_word_content
    *关键词
    */ 
    private java.lang.String keyWordContent;
    
    @Column(name = "key_word_content",length = 1073741824)
    public java.lang.String getKeyWordContent(){
        return this.keyWordContent;
    }
    
    public void setKeyWordContent(java.lang.String keyWordContent){
        this.keyWordContent = keyWordContent;
        super.addValidField("keyWordContent");
    }
    
  
    /** key_word_generate_status
    *关键词生成状态
    */ 
    private java.lang.String keyWordGenerateStatus;
    
    @Column(name = "key_word_generate_status",length = 15)
    public java.lang.String getKeyWordGenerateStatus(){
        return this.keyWordGenerateStatus;
    }
    
    public void setKeyWordGenerateStatus(java.lang.String keyWordGenerateStatus){
        this.keyWordGenerateStatus = keyWordGenerateStatus;
        super.addValidField("keyWordGenerateStatus");
    }
    
  
    /** meeting_summary_content
    *会议摘要
    */ 
    private java.lang.String meetingSummaryContent;
    
    @Column(name = "meeting_summary_content",length = 2147483647)
    public java.lang.String getMeetingSummaryContent(){
        return this.meetingSummaryContent;
    }
    
    public void setMeetingSummaryContent(java.lang.String meetingSummaryContent){
        this.meetingSummaryContent = meetingSummaryContent;
        super.addValidField("meetingSummaryContent");
    }
    
  
    /** meeting_summary_generate_status
    *会议摘要生成状态
    */ 
    private java.lang.String meetingSummaryGenerateStatus;
    
    @Column(name = "meeting_summary_generate_status",length = 15)
    public java.lang.String getMeetingSummaryGenerateStatus(){
        return this.meetingSummaryGenerateStatus;
    }
    
    public void setMeetingSummaryGenerateStatus(java.lang.String meetingSummaryGenerateStatus){
        this.meetingSummaryGenerateStatus = meetingSummaryGenerateStatus;
        super.addValidField("meetingSummaryGenerateStatus");
    }
    
  
    /** featured_questions_generate_status
    *推荐问生成状态
    */ 
    private java.lang.String featuredQuestionsGenerateStatus;
    
    @Column(name = "featured_questions_generate_status",length = 15)
    public java.lang.String getFeaturedQuestionsGenerateStatus(){
        return this.featuredQuestionsGenerateStatus;
    }
    
    public void setFeaturedQuestionsGenerateStatus(java.lang.String featuredQuestionsGenerateStatus){
        this.featuredQuestionsGenerateStatus = featuredQuestionsGenerateStatus;
        super.addValidField("featuredQuestionsGenerateStatus");
    }
    
  
    /** featured_questions
    *推荐问
    */ 
    private java.lang.String featuredQuestions;
    
    @Column(name = "featured_questions",length = 1073741824)
    public java.lang.String getFeaturedQuestions(){
        return this.featuredQuestions;
    }
    
    public void setFeaturedQuestions(java.lang.String featuredQuestions){
        this.featuredQuestions = featuredQuestions;
        super.addValidField("featuredQuestions");
    }
    
  
    /** is_deleted
    *是否删除 Y 是  N 否
    */ 
    private java.lang.String isDeleted;
    
    @Column(name = "is_deleted",length = 1)
    public java.lang.String getIsDeleted(){
        return this.isDeleted;
    }
    
    public void setIsDeleted(java.lang.String isDeleted){
        this.isDeleted = isDeleted;
        super.addValidField("isDeleted");
    }
    
  
    /** CREATOR
    *创建人
    */ 
    private java.lang.String creator;
    
    @Column(name = "CREATOR",length = 50)
    public java.lang.String getCreator(){
        return this.creator;
    }
    
    public void setCreator(java.lang.String creator){
        this.creator = creator;
        super.addValidField("creator");
    }
    
  
    /** CREATED_TIME
    *创建时间
    */ 
    private java.util.Date createdTime;
    
    @Column(name = "CREATED_TIME",length = 19)
    public java.util.Date getCreatedTime(){
        return this.createdTime;
    }
    
    public void setCreatedTime(java.util.Date createdTime){
        this.createdTime = createdTime;
        super.addValidField("createdTime");
    }
    
  
    /** MODIFIER
    *修改人
    */ 
    private java.lang.String modifier;
    
    @Column(name = "MODIFIER",length = 50)
    public java.lang.String getModifier(){
        return this.modifier;
    }
    
    public void setModifier(java.lang.String modifier){
        this.modifier = modifier;
        super.addValidField("modifier");
    }
    
  
    /** MODIFIED_TIME
    *修改时间
    */ 
    private java.util.Date modifiedTime;
    
    @Column(name = "MODIFIED_TIME",length = 19)
    public java.util.Date getModifiedTime(){
        return this.modifiedTime;
    }
    
    public void setModifiedTime(java.util.Date modifiedTime){
        this.modifiedTime = modifiedTime;
        super.addValidField("modifiedTime");
    }
    
  
    /** SYS_VERSION
    *乐观锁,版本号
    */ 
    private java.lang.Integer sysVersion;
    
    @Column(name = "SYS_VERSION",length = 10)
	@Version
    public java.lang.Integer getSysVersion(){
        return this.sysVersion;
    }
    
    public void setSysVersion(java.lang.Integer sysVersion){
        this.sysVersion = sysVersion;
        super.addValidField("sysVersion");
    }
    

}