package cn.com.poc.meeting.rest;

import cn.com.poc.meeting.dto.AiMeetingAssistantDto;
import cn.com.poc.meeting.dto.AnalysisTaskDetailDto;
import cn.com.yict.framemax.core.rest.BaseRest;
import cn.com.yict.framemax.web.permission.Access;
import cn.com.yict.framemax.web.permission.Permission;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;


/**
 * AI会议助手接口
 */
@Permission(Access.Safety)
public interface AiMeetingAssistantRest extends BaseRest {

    /**
     * 创建语音文件解析任务
     *
     * @param fileUrl     语音文件地址
     * @param dialoguesId 会话ID
     * @return 任务创建状态
     */
    String createTask(@RequestParam String fileUrl, @RequestParam String dialoguesId);

    /**
     * 查询会议内容分析详情
     *
     * @param dialoguesId 会话ID
     * @return 任务执行状态
     */
    AnalysisTaskDetailDto getTaskDetail(@RequestParam String dialoguesId);

    /**
     * 示例-查询会议内容分析详情
     *
     * @param dialoguesId 会话ID
     * @return 任务执行状态
     */
    AnalysisTaskDetailDto getExampleTaskDetail(@RequestParam String dialoguesId) throws Exception;


    /**
     * 会议助手对话
     *
     * @param dto
     * @throws Exception
     */
    void call(@RequestBody AiMeetingAssistantDto dto) throws Exception;
}
