package cn.com.poc.meeting.rest.impl;

import cn.com.poc.common.utils.Assert;
import cn.com.poc.common.utils.BlContext;
import cn.com.poc.meeting.aggregate.AiMeetingAssistantService;
import cn.com.poc.meeting.dto.AiMeetingAssistantDto;
import cn.com.poc.meeting.dto.AnalysisTaskDetailDto;
import cn.com.poc.meeting.entity.AnalysisTaskDetailEntity;
import cn.com.poc.meeting.rest.AiMeetingAssistantRest;
import cn.com.poc.support.security.oauth.entity.UserBaseEntity;
import cn.com.yict.framemax.core.exception.BusinessException;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Component
public class AiMeetingAssistantRestImpl implements AiMeetingAssistantRest {

    @Resource
    private AiMeetingAssistantService aiMeetingAssistantService;

    @Override
    public AnalysisTaskDetailDto getTaskDetail(String dialoguesId) {
        Assert.notBlank(dialoguesId, "会话ID不能为空");
        UserBaseEntity userBaseEntity = BlContext.getCurrentUserNotException();
        if (userBaseEntity == null) {
            throw new BusinessException("用户未登录");
        }
        AnalysisTaskDetailDto result = new AnalysisTaskDetailDto();
        AnalysisTaskDetailEntity analysisTaskDetailEntity = aiMeetingAssistantService.getTaskDetail(dialoguesId, userBaseEntity.getUserId());
        BeanUtils.copyProperties(analysisTaskDetailEntity, result);
        return result;
    }

    @Override
    public AnalysisTaskDetailDto getExampleTaskDetail(String dialoguesId) throws Exception {
        Assert.notBlank(dialoguesId, "会话ID不能为空");
        UserBaseEntity userBaseEntity = BlContext.getCurrentUserNotException();
        if (userBaseEntity == null) {
            throw new BusinessException("用户未登录");
        }
        AnalysisTaskDetailDto result = new AnalysisTaskDetailDto();
        AnalysisTaskDetailEntity analysisTaskDetailEntity = aiMeetingAssistantService.getExampleTaskDetail(dialoguesId);
        BeanUtils.copyProperties(analysisTaskDetailEntity, result);
        return result;
    }

    @Override
    public String createTask(String fileUrl, String dialoguesId) {
        Assert.notBlank(fileUrl, "文件不能为空");
        Assert.notBlank(dialoguesId, "会话ID不能为空");
        UserBaseEntity userBaseEntity = BlContext.getCurrentUserNotException();
        if (userBaseEntity == null) {
            throw new BusinessException("用户未登录");
        }
        return aiMeetingAssistantService.createTask(fileUrl, dialoguesId, userBaseEntity.getUserId());
    }

    @Override
    public void call(AiMeetingAssistantDto dto) throws Exception {
        Assert.notBlank(dto.getDialoguesId(), "会话ID不能为空");
        Assert.notBlank(dto.getInput(), "输入内容不能为空");
        UserBaseEntity userBaseEntity = BlContext.getCurrentUserNotException();
        if (userBaseEntity == null) {
            throw new BusinessException("用户未登录");
        }
        aiMeetingAssistantService.call(dto.getDialoguesId(), dto.getFileUrl(), dto.getInput(), dto.getKnowledgeIds(), userBaseEntity.getUserId());
    }
}
