package cn.com.poc.meeting.service.impl;

import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.poc.meeting.service.BizMeetingAssistantAnalysisTaskService;
import cn.com.poc.meeting.model.BizMeetingAssistantAnalysisTaskModel;
import cn.com.poc.meeting.entity.BizMeetingAssistantAnalysisTaskEntity;
import cn.com.poc.meeting.convert.BizMeetingAssistantAnalysisTaskConvert;
import cn.com.poc.meeting.repository.BizMeetingAssistantAnalysisTaskRepository;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.springframework.stereotype.Service;

import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.List;
import javax.annotation.Resource;

import org.springframework.util.Assert;

@Service
public class BizMeetingAssistantAnalysisTaskServiceImpl extends BaseServiceImpl
        implements BizMeetingAssistantAnalysisTaskService {

    @Resource
    private BizMeetingAssistantAnalysisTaskRepository repository;

    public BizMeetingAssistantAnalysisTaskEntity get(java.lang.Long id) {
        Assert.notNull(id);
        BizMeetingAssistantAnalysisTaskModel model = this.repository.get(id);
        if (model == null) {
            return null;
        }
        if ("Y".equals(model.getIsDeleted())) {
            return null;
        }
        return BizMeetingAssistantAnalysisTaskConvert.modelToEntity(model);
    }


    public List<BizMeetingAssistantAnalysisTaskEntity> findByExample(BizMeetingAssistantAnalysisTaskEntity example, PagingInfo pagingInfo) {
        List<BizMeetingAssistantAnalysisTaskEntity> result = new ArrayList<BizMeetingAssistantAnalysisTaskEntity>();
        BizMeetingAssistantAnalysisTaskModel model = new BizMeetingAssistantAnalysisTaskModel();
        if (example != null) {
            model = BizMeetingAssistantAnalysisTaskConvert.entityToModel(example);
        }
        model.setIsDeleted("N");
        List<BizMeetingAssistantAnalysisTaskModel> models = this.repository.findByExample(model, pagingInfo);
        if (CollectionUtils.isNotEmpty(models)) {
            result = models.stream().map(BizMeetingAssistantAnalysisTaskConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    public BizMeetingAssistantAnalysisTaskEntity save(BizMeetingAssistantAnalysisTaskEntity entity) throws Exception {
        Assert.notNull(entity);
        entity.setId(null);
        entity.setIsDeleted("N");
        BizMeetingAssistantAnalysisTaskModel model = BizMeetingAssistantAnalysisTaskConvert.entityToModel(entity);
        BizMeetingAssistantAnalysisTaskModel saveModel = this.repository.save(model);
        return BizMeetingAssistantAnalysisTaskConvert.modelToEntity(saveModel);
    }

    public BizMeetingAssistantAnalysisTaskEntity update(BizMeetingAssistantAnalysisTaskEntity entity) {
        Assert.notNull(entity);
        Assert.notNull(entity.getId(), "update pk can not be null");
        BizMeetingAssistantAnalysisTaskModel model = this.repository.get(entity.getId());

        if (entity.getDiaguesId() != null) {
            model.setDiaguesId(entity.getDiaguesId());
        }
        if (entity.getAnalysisStatus() != null) {
            model.setAnalysisStatus(entity.getAnalysisStatus());
        }
        if (entity.getThemeContent() != null) {
            model.setThemeContent(entity.getThemeContent());
        }
        if (entity.getThemeGenerateStatus() != null) {
            model.setThemeGenerateStatus(entity.getThemeGenerateStatus());
        }
        if (entity.getKeyWordContent() != null) {
            model.setKeyWordContent(entity.getKeyWordContent());
        }
        if (entity.getKeyWordGenerateStatus() != null) {
            model.setKeyWordGenerateStatus(entity.getKeyWordGenerateStatus());
        }
        if (entity.getMeetingSummaryContent() != null) {
            model.setMeetingSummaryContent(entity.getMeetingSummaryContent());
        }
        if (entity.getMeetingSummaryGenerateStatus() != null) {
            model.setMeetingSummaryGenerateStatus(entity.getMeetingSummaryGenerateStatus());
        }
        if (entity.getFeaturedQuestions() != null) {
            model.setFeaturedQuestions(entity.getFeaturedQuestions());
        }
        if (entity.getFeaturedQuestionsGenerateStatus() != null) {
            model.setFeaturedQuestionsGenerateStatus(entity.getFeaturedQuestionsGenerateStatus());
        }
        if (entity.getMemberId() != null) {
            model.setMemberId(entity.getMemberId());
        }
        if (entity.getIsDeleted() != null) {
            model.setIsDeleted(entity.getIsDeleted());
        }
        if (entity.getCreator() != null) {
            model.setCreator(entity.getCreator());
        }
        if (entity.getCreatedTime() != null) {
            model.setCreatedTime(entity.getCreatedTime());
        }
        if (entity.getModifier() != null) {
            model.setModifier(entity.getModifier());
        }
        if (entity.getModifiedTime() != null) {
            model.setModifiedTime(entity.getModifiedTime());
        }
        if (entity.getSysVersion() != null) {
            model.setSysVersion(entity.getSysVersion());
        }
        BizMeetingAssistantAnalysisTaskModel saveModel = this.repository.save(model);
        return BizMeetingAssistantAnalysisTaskConvert.modelToEntity(saveModel);
    }

    public void deletedById(java.lang.Long id) {
        Assert.notNull(id);
        BizMeetingAssistantAnalysisTaskModel model = this.repository.get(id);
        if (model != null) {
            if ("N".equals(model.getIsDeleted())) {
                model.setIsDeleted("Y");
                this.repository.save(model);
            }
        }
    }

}