package cn.com.poc.meeting.service.impl;

import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.poc.meeting.service.BizMeetingAssistantAsrTaskService;
import cn.com.poc.meeting.model.BizMeetingAssistantAsrTaskModel;
import cn.com.poc.meeting.entity.BizMeetingAssistantAsrTaskEntity;
import cn.com.poc.meeting.convert.BizMeetingAssistantAsrTaskConvert;
import cn.com.poc.meeting.repository.BizMeetingAssistantAsrTaskRepository;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.springframework.stereotype.Service;

import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.List;
import javax.annotation.Resource;

import org.springframework.util.Assert;

@Service
public class BizMeetingAssistantAsrTaskServiceImpl extends BaseServiceImpl
        implements BizMeetingAssistantAsrTaskService {

    @Resource
    private BizMeetingAssistantAsrTaskRepository repository;

    public BizMeetingAssistantAsrTaskEntity get(java.lang.Long id) throws Exception {
        Assert.notNull(id);
        BizMeetingAssistantAsrTaskModel model = this.repository.get(id);
        if (model == null) {
            return null;
        }
        if ("Y".equals(model.getIsDeleted())) {
            return null;
        }
        return BizMeetingAssistantAsrTaskConvert.modelToEntity(model);
    }


    public List<BizMeetingAssistantAsrTaskEntity> findByExample(BizMeetingAssistantAsrTaskEntity example, PagingInfo pagingInfo) {
        List<BizMeetingAssistantAsrTaskEntity> result = new ArrayList<BizMeetingAssistantAsrTaskEntity>();
        BizMeetingAssistantAsrTaskModel model = new BizMeetingAssistantAsrTaskModel();
        if (example != null) {
            model = BizMeetingAssistantAsrTaskConvert.entityToModel(example);
        }
        model.setIsDeleted("N");
        List<BizMeetingAssistantAsrTaskModel> models = this.repository.findByExample(model, pagingInfo);
        if (CollectionUtils.isNotEmpty(models)) {
            result = models.stream().map(BizMeetingAssistantAsrTaskConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    public BizMeetingAssistantAsrTaskEntity save(BizMeetingAssistantAsrTaskEntity entity) throws Exception {
        Assert.notNull(entity);
        entity.setId(null);
        entity.setIsDeleted("N");
        BizMeetingAssistantAsrTaskModel model = BizMeetingAssistantAsrTaskConvert.entityToModel(entity);
        BizMeetingAssistantAsrTaskModel saveModel = this.repository.save(model);
        return BizMeetingAssistantAsrTaskConvert.modelToEntity(saveModel);
    }

    public BizMeetingAssistantAsrTaskEntity update(BizMeetingAssistantAsrTaskEntity entity) {
        Assert.notNull(entity);
        Assert.notNull(entity.getId(), "update pk can not be null");
        BizMeetingAssistantAsrTaskModel model = this.repository.get(entity.getId());

        if (entity.getMemberId() != null) {
            model.setMemberId(entity.getMemberId());
        }
        if (entity.getDiaguesId() != null) {
            model.setDiaguesId(entity.getDiaguesId());
        }
        if (entity.getSessionId() != null) {
            model.setSessionId(entity.getSessionId());
        }
        if (entity.getGenerateStatus() != null) {
            model.setGenerateStatus(entity.getGenerateStatus());
        }
        if (entity.getMessage() != null) {
            model.setMessage(entity.getMessage());
        }
        if (entity.getIsDeleted() != null) {
            model.setIsDeleted(entity.getIsDeleted());
        }
        if (entity.getCreator() != null) {
            model.setCreator(entity.getCreator());
        }
        if (entity.getCreatedTime() != null) {
            model.setCreatedTime(entity.getCreatedTime());
        }
        if (entity.getModifier() != null) {
            model.setModifier(entity.getModifier());
        }
        if (entity.getModifiedTime() != null) {
            model.setModifiedTime(entity.getModifiedTime());
        }
        if (entity.getSysVersion() != null) {
            model.setSysVersion(entity.getSysVersion());
        }
        BizMeetingAssistantAsrTaskModel saveModel = this.repository.save(model);
        return BizMeetingAssistantAsrTaskConvert.modelToEntity(saveModel);
    }

    public void deletedById(java.lang.Long id) throws Exception {
        Assert.notNull(id);
        BizMeetingAssistantAsrTaskModel model = this.repository.get(id);
        if (model != null) {
            if ("N".equals(model.getIsDeleted())) {
                model.setIsDeleted("Y");
                this.repository.save(model);
            }
        }
    }

}