
package cn.com.poc.message.service.impl;

import cn.com.poc.data_analyze.entity.BizDataAnalyzeCollectEntity;
import cn.com.poc.data_analyze.service.BizDataAnalyzeCollectService;
import cn.com.poc.message.entity.DataAnalyzeCollectMessage;
import cn.com.poc.message.service.DataAnalyzeConsumerService;
import cn.com.poc.message.topic.DataAnalyzeTopic;
import cn.com.yict.framemax.core.service.BaseService;
import cn.com.yict.framemax.tumbleweed.client.annotation.Consumer;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

/**
 * @author alex.yao
 * @date 2024/12/10
 */
@Service
public class DataAnalyzeConsumerServiceImpl implements DataAnalyzeConsumerService {

    @Resource
    private BizDataAnalyzeCollectService bizDataAnalyzeCollectService;

    /**
     * 数据上报-汇总表
     *
     * @param message
     * @return
     */
    @Consumer(topic = DataAnalyzeTopic.DATA_ANALYZE_COLLECT, scale = 1)
    public void dataReport(DataAnalyzeCollectMessage message) throws Exception {
        Date dataDate = message.getDataDate();
        String relationId = message.getRelationId();
        String channel = message.getChannel();
        String type = message.getType();
        BizDataAnalyzeCollectEntity bizDataAnalyzeCollectEntity = new BizDataAnalyzeCollectEntity();
        bizDataAnalyzeCollectEntity.setRelationId(relationId);
        bizDataAnalyzeCollectEntity.setType(type);
        bizDataAnalyzeCollectEntity.setChannel(channel);
        bizDataAnalyzeCollectEntity.setDataDate(dataDate);
        List<BizDataAnalyzeCollectEntity> collectEntities = bizDataAnalyzeCollectService.findByExample(bizDataAnalyzeCollectEntity, null);
        if (CollectionUtils.isNotEmpty(collectEntities)) {
            //
        }

    }
}