package cn.com.poc.message.service.impl;

import cn.com.poc.message.entity.meeting.AnalysisTaskUpdateMessage;
import cn.com.poc.message.entity.meeting.MeetingAssistantAnalysisMessage;
import cn.com.poc.message.entity.meeting.MeetingAssistantGenerateAnalysisContentMessage;
import cn.com.poc.message.service.MeetingAssistantAnalysisProducerService;
import cn.com.poc.message.topic.MeetingAssistantTopic;
import cn.com.yict.framemax.tumbleweed.client.annotation.Producer;
import org.springframework.stereotype.Service;

@Service
public class MeetingAssistantAnalysisProducerServiceImpl implements MeetingAssistantAnalysisProducerService {

    @Override
    @Producer(topic = MeetingAssistantTopic.CONTENT_ANALYSIS)
    public MeetingAssistantAnalysisMessage analysisTask(MeetingAssistantAnalysisMessage meetingAssistantAnalysisMessage) {
        return meetingAssistantAnalysisMessage;
    }

    @Override
    @Producer(topic = MeetingAssistantTopic.UPDATE_ANALYSIS)
    public AnalysisTaskUpdateMessage analysisTaskUpdate(AnalysisTaskUpdateMessage message)  {
        return message;
    }

    @Override
    @Producer(topic = MeetingAssistantTopic.GENERATE_FEATURED_QUESTION)
    public MeetingAssistantGenerateAnalysisContentMessage generateFeaturedQuestion(MeetingAssistantGenerateAnalysisContentMessage message) {
        return message;
    }

    @Override
    @Producer(topic = MeetingAssistantTopic.GENERATE_SUMMARY)
    public MeetingAssistantGenerateAnalysisContentMessage generateSummry(MeetingAssistantGenerateAnalysisContentMessage message) {
        return message;
    }

    @Override
    @Producer(topic = MeetingAssistantTopic.GENERATE_KEYWORD)
    public MeetingAssistantGenerateAnalysisContentMessage keyWord(MeetingAssistantGenerateAnalysisContentMessage message) {
        return message;
    }

    @Override
    @Producer(topic = MeetingAssistantTopic.GENERATE_THEME)
    public MeetingAssistantGenerateAnalysisContentMessage generateTheme(MeetingAssistantGenerateAnalysisContentMessage message) {
        return message;
    }
}
