package cn.com.poc.message.service.impl;

import cn.com.poc.common.model.BizFileUploadRecordModel;
import cn.com.poc.common.service.BizFileUploadRecordService;
import cn.com.poc.common.service.BosConfigService;
import cn.com.poc.common.utils.DocumentLoad;
import cn.com.poc.common.utils.MD2Json;
import cn.com.poc.common.utils.StringUtils;
import cn.com.poc.common.utils.UUIDTool;
import cn.com.poc.message.entity.OCRMessage;
import cn.com.poc.message.entity.OCRStatusMessage;
import cn.com.poc.message.service.OcrConsumerService;
import cn.com.poc.message.service.OcrProducerService;
import cn.com.poc.message.topic.OCRTopic;
import cn.com.poc.ocr.entity.BizFileOcrCacheEntity;
import cn.com.poc.ocr.service.BizFileOcrCacheService;
import cn.com.poc.thirdparty.resource.minerU.MdContent;
import cn.com.poc.thirdparty.resource.minerU.MinerUResponse;
import cn.com.poc.thirdparty.resource.minerU.MinerUResult;
import cn.com.poc.thirdparty.resource.minerU.api.MinerUAPI;
import cn.com.yict.framemax.core.exception.BusinessException;
import cn.com.yict.framemax.tumbleweed.client.annotation.Consumer;
import cn.hutool.core.io.FileUtil;
import cn.hutool.crypto.digest.MD5;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

/**
 * @author alex.yao
 * @date 2025/10/30
 */
@Service
public class OcrConsumerServiceImpl implements OcrConsumerService {

    private Logger logger = LoggerFactory.getLogger(OcrConsumerService.class);

    @Resource
    private MinerUAPI minerUAPI;

    @Resource
    private BizFileOcrCacheService bizFileOcrCacheService;

    @Resource
    private BosConfigService bosConfigService;

    @Resource
    private BizFileUploadRecordService bizFileUploadRecordService;

    @Resource
    private OcrProducerService ocrProducerService;


    @Override
    @Consumer(topic = OCRTopic.PARSE_PDF)
    public void OCR(OCRMessage message) {
        OCRStatusMessage ocrStatusMessage = new OCRStatusMessage();
        ocrStatusMessage.setId(message.getId());
        ocrStatusMessage.setStatus("parsing");
        ocrProducerService.updateStatus(ocrStatusMessage);
        try {
            File file = DocumentLoad.downloadURLDocument(message.getFileURL());
            MinerUResponse minerUResponse = new MinerUResponse();
            minerUResponse.setFiles(file);
            MinerUResult minerUResult = minerUAPI.parsePDF(minerUResponse);
            if (minerUResult == null) {
                throw new BusinessException("解析失败 minerU 返回为空");
            }

            String md = StringUtils.EMPTY;
            for (String key : minerUResult.getResults().keySet()) {
                MdContent mdContent = minerUResult.getResults().get(key);
                md = mdContent.getMd_content();
            }

            BizFileOcrCacheEntity updateEntity = bizFileOcrCacheService.get(message.getId());
            updateEntity.setParseStatus("complete");
            String fileName = bizFileUploadRecordService.getFileNameByFileUrl(message.getFileURL());
            if (fileName.equals("Form.pdf")) {
                String json = MD2Json.md2json(md);
                updateEntity.setJsonFileUrl(createFileAndUploadBos(json, "txt"));
            }
            updateEntity.setMdFileUrl(createFileAndUploadBos(md, "md"));
            bizFileOcrCacheService.update(updateEntity);

        } catch (Exception e) {
            logger.error("----------- OCR 失败 {} ----------", e.getMessage());
            OCRStatusMessage errorOcrStatusMessage = new OCRStatusMessage();
            errorOcrStatusMessage.setId(message.getId());
            errorOcrStatusMessage.setStatus("fail");
            ocrProducerService.updateStatus(errorOcrStatusMessage);
        }

    }

    @Override
    @Consumer(topic = OCRTopic.UPDATE_STATUS)
    public void updateStatus(OCRStatusMessage message) throws Exception {
        logger.info("update ocr status , id:{} , status:{}", message.getId(), message.getStatus());
        BizFileOcrCacheEntity bizFileOcrCacheEntity = bizFileOcrCacheService.get(message.getId());
        bizFileOcrCacheEntity.setParseStatus(message.getStatus());
        bizFileOcrCacheService.update(bizFileOcrCacheEntity);
    }

    private String createFileAndUploadBos(String content, String suffix) throws IOException {
        String fileName = UUIDTool.getUUID();
        File tempFile = File.createTempFile(fileName, suffix);

        FileOutputStream fileOutputStream = new FileOutputStream(tempFile);
        fileOutputStream.write(content.getBytes());
        fileOutputStream.flush();
        fileOutputStream.close();

        BufferedInputStream inputStream = FileUtil.getInputStream(tempFile);
        byte[] bytes = new byte[inputStream.available()];
        inputStream.read(bytes);
        String md5 = MD5.create().digestHex(bytes);
        String upload = bosConfigService.uploadFileByByteArray2Oss(bytes, fileName, suffix);

        tempFile.delete();
        BizFileUploadRecordModel bizFileUploadRecordModel = new BizFileUploadRecordModel();
        bizFileUploadRecordModel.setFileName(fileName);
        bizFileUploadRecordModel.setFileUrl(upload);
        bizFileUploadRecordModel.setMd5(md5);
        bizFileUploadRecordModel.setCoverSheetUrl("");
        bizFileUploadRecordService.save(bizFileUploadRecordModel);

        return upload;

    }
}
