package cn.com.poc.message.service.impl;

import cn.com.poc.message.entity.OCRMessage;
import cn.com.poc.message.entity.OCRStatusMessage;
import cn.com.poc.message.service.OcrProducerService;
import cn.com.poc.message.topic.OCRTopic;
import cn.com.yict.framemax.tumbleweed.client.annotation.Producer;
import cn.com.yict.framemax.tumbleweed.constant.PublishPoint;
import org.springframework.stereotype.Service;

/**
 * @author alex.yao
 * @date 2025/10/30
 */
@Service
public class OcrProducerServiceImpl implements OcrProducerService {

    @Override
    @Producer(topic = OCRTopic.PARSE_PDF)
    public OCRMessage OCR(OCRMessage message) {
        return message;
    }

    @Override
    @Producer(topic = OCRTopic.UPDATE_STATUS, publishPoint = PublishPoint.PUBLISH_REAL_TIME)
    public OCRStatusMessage updateStatus(OCRStatusMessage message) {
        return message;
    }
}
