package cn.com.poc.ocr.model;

import java.io.Serializable;

import cn.com.yict.framemax.data.model.BaseModelClass;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Id;

import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Version;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;

/**
 * Model class for biz_file_ocr_cache
 * 文件OCR结果缓存
 */
@Entity
@Table(name = "biz_file_ocr_cache")
@DynamicInsert
@DynamicUpdate
public class BizFileOcrCacheModel extends BaseModelClass implements Serializable {

    private static final long serialVersionUID = 1L;


    /**
     * id
     * 主键id
     */
    private java.lang.Long id;

    @Column(name = "id", length = 19)
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    public java.lang.Long getId() {
        return this.id;
    }

    public void setId(java.lang.Long id) {
        this.id = id;
        super.addValidField("id");
    }


    /**
     * md5
     * 文件MD5
     */
    private java.lang.String md5;

    @Column(name = "md5", length = 200)
    public java.lang.String getMd5() {
        return this.md5;
    }

    public void setMd5(java.lang.String md5) {
        this.md5 = md5;
        super.addValidField("md5");
    }

    /**
     * parse_status
     * 解析状态  : create-已创建 queuing-排队中  parsing -解析中  complete-完成 fail-失败
     */
    private String parseStatus;

    @Column(name = "parse_status", length = 10)
    public String getParseStatus() {
        return parseStatus;
    }

    public void setParseStatus(String parseStatus) {
        this.parseStatus = parseStatus;
        super.addValidField("parseStatus");
    }


    /**
     * file_url
     * 源文件地址
     */
    private java.lang.String fileUrl;

    @Column(name = "file_url", length = 200)
    public java.lang.String getFileUrl() {
        return this.fileUrl;
    }

    public void setFileUrl(java.lang.String fileUrl) {
        this.fileUrl = fileUrl;
        super.addValidField("fileUrl");
    }


    /**
     * md_file_url
     * OCR后MD文件地址
     */
    private java.lang.String mdFileUrl;

    @Column(name = "md_file_url", length = 200)
    public java.lang.String getMdFileUrl() {
        return this.mdFileUrl;
    }

    public void setMdFileUrl(java.lang.String mdFileUrl) {
        this.mdFileUrl = mdFileUrl;
        super.addValidField("mdFileUrl");
    }


    /**
     * json_file_url
     * 提取json后文件url
     */
    private java.lang.String jsonFileUrl;

    @Column(name = "json_file_url", length = 200)
    public java.lang.String getJsonFileUrl() {
        return this.jsonFileUrl;
    }

    public void setJsonFileUrl(java.lang.String jsonFileUrl) {
        this.jsonFileUrl = jsonFileUrl;
        super.addValidField("jsonFileUrl");
    }


    /**
     * is_deleted
     * 是否删除 Y 是  N 否
     */
    private java.lang.String isDeleted;

    @Column(name = "is_deleted", length = 1)
    public java.lang.String getIsDeleted() {
        return this.isDeleted;
    }

    public void setIsDeleted(java.lang.String isDeleted) {
        this.isDeleted = isDeleted;
        super.addValidField("isDeleted");
    }


    /**
     * CREATOR
     * 创建人
     */
    private java.lang.String creator;

    @Column(name = "CREATOR", length = 50)
    public java.lang.String getCreator() {
        return this.creator;
    }

    public void setCreator(java.lang.String creator) {
        this.creator = creator;
        super.addValidField("creator");
    }


    /**
     * CREATED_TIME
     * 创建时间
     */
    private java.util.Date createdTime;

    @Column(name = "CREATED_TIME", length = 19)
    public java.util.Date getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(java.util.Date createdTime) {
        this.createdTime = createdTime;
        super.addValidField("createdTime");
    }


    /**
     * MODIFIER
     * 修改人
     */
    private java.lang.String modifier;

    @Column(name = "MODIFIER", length = 50)
    public java.lang.String getModifier() {
        return this.modifier;
    }

    public void setModifier(java.lang.String modifier) {
        this.modifier = modifier;
        super.addValidField("modifier");
    }


    /**
     * MODIFIED_TIME
     * 修改时间
     */
    private java.util.Date modifiedTime;

    @Column(name = "MODIFIED_TIME", length = 19)
    public java.util.Date getModifiedTime() {
        return this.modifiedTime;
    }

    public void setModifiedTime(java.util.Date modifiedTime) {
        this.modifiedTime = modifiedTime;
        super.addValidField("modifiedTime");
    }


    /**
     * SYS_VERSION
     * 乐观锁,版本号
     */
    private java.lang.Integer sysVersion;

    @Column(name = "SYS_VERSION", length = 10)
    @Version
    public java.lang.Integer getSysVersion() {
        return this.sysVersion;
    }

    public void setSysVersion(java.lang.Integer sysVersion) {
        this.sysVersion = sysVersion;
        super.addValidField("sysVersion");
    }


}