package cn.com.poc.ocr.rest.impl;	

import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;
import cn.com.poc.ocr.rest.BizFileOcrCacheRest;
import cn.com.poc.ocr.service.BizFileOcrCacheService;
import cn.com.poc.ocr.dto.BizFileOcrCacheDto;
import cn.com.poc.ocr.entity.BizFileOcrCacheEntity;
import cn.com.yict.framemax.data.model.PagingInfo;
import cn.com.poc.ocr.convert.BizFileOcrCacheConvert;
import java.util.stream.Collectors;
import org.springframework.util.Assert;

@Component
public class BizFileOcrCacheRestImpl implements BizFileOcrCacheRest {
   
   	@Resource
    private BizFileOcrCacheService service;
    			 
	public BizFileOcrCacheDto getById(java.lang.Long id) throws Exception{
		Assert.notNull(id);
 		return BizFileOcrCacheConvert.entityToDto(service.get(id));
   	}
    
   	public List<BizFileOcrCacheDto> getList(BizFileOcrCacheDto dto,PagingInfo pagingInfo) throws Exception{
       	return service
		        .findByExample(BizFileOcrCacheConvert.dtoToEntity(dto),pagingInfo)
		        .stream()
				.map(BizFileOcrCacheConvert::entityToDto)
				.collect(Collectors.toList());
   	}

   	public BizFileOcrCacheDto save(BizFileOcrCacheDto dto) throws Exception{
		Assert.notNull(dto);
		BizFileOcrCacheEntity entity = BizFileOcrCacheConvert.dtoToEntity(dto);
       	return BizFileOcrCacheConvert.entityToDto(service.save(entity));
   	}
    
	
    public BizFileOcrCacheDto update(BizFileOcrCacheDto dto) throws Exception{
		Assert.notNull(dto);
		BizFileOcrCacheEntity entity = BizFileOcrCacheConvert.dtoToEntity(dto);
       	return BizFileOcrCacheConvert.entityToDto(service.update(entity));
	}

    public void deletedById(java.lang.Long id) throws Exception{
		Assert.notNull(id);
		service.deletedById(id);
	}
}