package cn.com.poc.ocr.service.impl;

import cn.com.poc.common.constant.CommonConstant;
import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.poc.ocr.service.BizFileOcrCacheService;
import cn.com.poc.ocr.model.BizFileOcrCacheModel;
import cn.com.poc.ocr.entity.BizFileOcrCacheEntity;
import cn.com.poc.ocr.convert.BizFileOcrCacheConvert;
import cn.com.poc.ocr.repository.BizFileOcrCacheRepository;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.springframework.stereotype.Service;

import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.List;
import javax.annotation.Resource;

import org.springframework.util.Assert;

@Service
public class BizFileOcrCacheServiceImpl extends BaseServiceImpl
        implements BizFileOcrCacheService {

    @Resource
    private BizFileOcrCacheRepository repository;

    public BizFileOcrCacheEntity get(java.lang.Long id) throws Exception {
        Assert.notNull(id);
        BizFileOcrCacheModel model = this.repository.get(id);
        if (model == null) {
            return null;
        }
        if ("Y".equals(model.getIsDeleted())) {
            return null;
        }
        return BizFileOcrCacheConvert.modelToEntity(model);
    }


    public List<BizFileOcrCacheEntity> findByExample(BizFileOcrCacheEntity example, PagingInfo pagingInfo) throws Exception {
        List<BizFileOcrCacheEntity> result = new ArrayList<BizFileOcrCacheEntity>();
        BizFileOcrCacheModel model = new BizFileOcrCacheModel();
        if (example != null) {
            model = BizFileOcrCacheConvert.entityToModel(example);
        }
        model.setIsDeleted("N");
        List<BizFileOcrCacheModel> models = this.repository.findByExample(model, pagingInfo);
        if (CollectionUtils.isNotEmpty(models)) {
            result = models.stream().map(BizFileOcrCacheConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    public BizFileOcrCacheEntity save(BizFileOcrCacheEntity entity) throws Exception {
        Assert.notNull(entity);
        entity.setId(null);
        entity.setIsDeleted("N");
        BizFileOcrCacheModel model = BizFileOcrCacheConvert.entityToModel(entity);
        BizFileOcrCacheModel saveModel = this.repository.save(model);
        return BizFileOcrCacheConvert.modelToEntity(saveModel);
    }

    public BizFileOcrCacheEntity update(BizFileOcrCacheEntity entity) throws Exception {
        Assert.notNull(entity);
        Assert.notNull(entity.getId(), "update pk can not be null");
        BizFileOcrCacheModel model = this.repository.get(entity.getId());

        if (entity.getMd5() != null) {
            model.setMd5(entity.getMd5());
        }
        if (entity.getFileUrl() != null) {
            model.setFileUrl(entity.getFileUrl());
        }
        if (entity.getParseStatus() != null) {
            model.setParseStatus(entity.getParseStatus());
        }
        if (entity.getMdFileUrl() != null) {
            model.setMdFileUrl(entity.getMdFileUrl());
        }
        if (entity.getJsonFileUrl() != null) {
            model.setJsonFileUrl(entity.getJsonFileUrl());
        }
        if (entity.getIsDeleted() != null) {
            model.setIsDeleted(entity.getIsDeleted());
        }
        if (entity.getCreator() != null) {
            model.setCreator(entity.getCreator());
        }
        if (entity.getCreatedTime() != null) {
            model.setCreatedTime(entity.getCreatedTime());
        }
        if (entity.getModifier() != null) {
            model.setModifier(entity.getModifier());
        }
        if (entity.getModifiedTime() != null) {
            model.setModifiedTime(entity.getModifiedTime());
        }
        if (entity.getSysVersion() != null) {
            model.setSysVersion(entity.getSysVersion());
        }
        BizFileOcrCacheModel saveModel = this.repository.save(model);
        return BizFileOcrCacheConvert.modelToEntity(saveModel);
    }

    public void deletedById(java.lang.Long id) throws Exception {
        Assert.notNull(id);
        BizFileOcrCacheModel model = this.repository.get(id);
        if (model != null) {
            if ("N".equals(model.getIsDeleted())) {
                model.setIsDeleted("Y");
                this.repository.save(model);
            }
        }
    }

    @Override
    public BizFileOcrCacheEntity findByMd5(String md5)  {
        BizFileOcrCacheModel bizFileOcrCacheModel = new BizFileOcrCacheModel();
        bizFileOcrCacheModel.setMd5(md5);
        bizFileOcrCacheModel.setIsDeleted(CommonConstant.IsDeleted.N);
        List<BizFileOcrCacheModel> models = this.repository.findByExample(bizFileOcrCacheModel, null);
        return CollectionUtils.isNotEmpty(models) ? BizFileOcrCacheConvert.modelToEntity(models.get(0)) : null;
    }
}