package cn.com.poc.portal.aggregate.impl;

import cn.com.poc.agent_application.aggregate.AgentApplicationService;
import cn.com.poc.agent_application.constant.AgentApplicationDialoguesRecordConstants;
import cn.com.poc.agent_application.domain.FunctionResult;
import cn.com.poc.agent_application.entity.*;
import cn.com.poc.agent_application.service.*;
import cn.com.poc.agent_application.utils.AgentApplicationTools;
import cn.com.poc.ai_dialogues.entity.BizAiDialoguesEntity;
import cn.com.poc.ai_dialogues.service.BizAiDialoguesService;
import cn.com.poc.common.constant.CommonConstant;
import cn.com.poc.common.constant.FmxParamConfigConstant;
import cn.com.poc.common.utils.*;
import cn.com.poc.knowledge.aggregate.KnowledgeService;
import cn.com.poc.knowledge.constant.KnowledgeConstant;
import cn.com.poc.knowledge.entity.BizKnowledgeDocumentEntity;
import cn.com.poc.knowledge.query.KnowledgeDocumentRelationQueryItem;
import cn.com.poc.knowledge.service.BizKnowledgeDocumentService;
import cn.com.poc.long_document.domain.LongtextDialoguesResult;
import cn.com.poc.portal.aggregate.PortalService;
import cn.com.poc.portal.entity.BizPortalDialoguesEntity;
import cn.com.poc.portal.entity.PortalDialoguesCallEntity;
import cn.com.poc.portal.service.BizPortalDialoguesService;
import cn.com.poc.thirdparty.resource.demand.ai.aggregate.DemandKnowledgeService;
import cn.com.poc.thirdparty.resource.demand.ai.constants.KnowledgeSearchTypeEnum;
import cn.com.poc.thirdparty.resource.demand.ai.constants.LLMRoleEnum;
import cn.com.poc.thirdparty.resource.demand.ai.entity.dialogue.*;
import cn.com.poc.thirdparty.resource.demand.ai.entity.function.FunctionCallResult;
import cn.com.poc.thirdparty.resource.demand.ai.entity.knowledge.SearchKnowledgeResult;
import cn.com.poc.thirdparty.resource.demand.ai.entity.largemodel.LargeModelDemandResult;
import cn.com.poc.thirdparty.resource.demand.ai.entity.largemodel.LargeModelResponse;
import cn.com.poc.thirdparty.resource.demand.ai.function.AbstractFunctionResult;
import cn.com.poc.thirdparty.resource.demand.ai.function.web_seach.WebSearchFunction;
import cn.com.poc.thirdparty.resource.demand.ai.function.web_seach.WebSearchFunctionResult;
import cn.com.poc.thirdparty.service.LLMService;
import cn.com.poc.writing.dto.AiWritingTitleGenerationDto;
import cn.com.poc.writing.entity.BizAiWritingDialoguesRecordEntity;
import cn.com.yict.framemax.core.exception.BusinessException;
import cn.com.yict.framemax.frame.service.FmxParamConfigService;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import static cn.com.poc.common.constant.XLangConstant.*;

/**
 * @author alex.yao
 * @date 2025/6/19
 */
@Service
public class PortalServiceImpl implements PortalService {

    private final Logger logger = LoggerFactory.getLogger(PortalService.class);

    @Resource
    private BizAgentApplicationGcConfigService bizAgentApplicationGcConfigService;

    @Resource
    private KnowledgeService knowledgeService;

    @Resource
    private BizKnowledgeDocumentService bizKnowledgeDocumentService;

    @Resource
    private DemandKnowledgeService demandKnowledgeService;

    @Resource
    private BizAgentApplicationDialoguesRecordService bizAgentApplicationDialoguesRecordService;

    @Resource
    private LLMService llmService;

    @Resource
    private WebSearchFunction webSearchFunction;

    @Resource
    private BizAgentApplicationPluginService bizAgentApplicationPluginService;

    @Resource
    private BizAiDialoguesService bizAiDialoguesService;

    @Override
    public void call(PortalDialoguesCallEntity callEntity, Long userId) throws Exception {


        BizAiDialoguesEntity bizAiDialoguesEntity = new BizAiDialoguesEntity();
        bizAiDialoguesEntity.setDialoguesId(callEntity.getDialoguesId());
        bizAiDialoguesEntity.setMemberId(userId);
        bizAiDialoguesEntity.setIsDeleted(CommonConstant.IsDeleted.N);
        List<BizAiDialoguesEntity> bizAiDialoguesEntities = bizAiDialoguesService.findByExample(bizAiDialoguesEntity, null);
        if (CollectionUtils.isEmpty(bizAiDialoguesEntities)) {
            throw new BusinessException("当前对话不存在");
        }
        BizAiDialoguesEntity aiDialoguesEntity = bizAiDialoguesEntities.get(0);
        if (StringUtils.isBlank(aiDialoguesEntity.getTitle())) {
            aiDialoguesEntity.setTitle(callEntity.getInput());
            bizAiDialoguesService.update(aiDialoguesEntity);
        }

        //记录提问时间
        long inputTimestamp = System.currentTimeMillis();
        SSEUtil sseUtil = new SSEUtil();
        // 知识库
        //获取知识库配置
        List<Integer> kdIds = knowledgeService.getKdIdsByKnowledgeInfoIds(callEntity.getKnowledgeIds());
        List<KnowledgeContentResult> knowledgeResult = knowledge(kdIds, callEntity.getInput(), 5, 0.5, KnowledgeSearchTypeEnum.MIX);

        if (CollectionUtils.isNotEmpty(knowledgeResult)) {
            LargeModelDemandResult result = new LargeModelDemandResult();
            result.setCode("0");
            result.setFunction(null);
            result.setDbChainResult(null);
            result.setKnowledgeContentResult(knowledgeResult);
            sseUtil.send(JsonUtils.serialize(result));
        }

        // 插件调用
        ToolFunction toolFunction = null;
        if (callEntity.getEnableSearchEngine()) {
            List<Message> messages = new ArrayList<>();
            Message message = new Message();
            message.setRole("user");
            message.setContent(callEntity.getInput());
            messages.add(message);

            String[] unitIds = new String[1];
            unitIds[0] = "web_search";
            List<Tool> tools = AgentApplicationTools.buildFunctionConfig(null, "N", callEntity.getDialoguesId(), callEntity.getDialoguesId(), unitIds, "N");
            CheckPluginUseEntity checkPluginUseEntity = AgentApplicationTools.checkPluginUse(messages, tools, null);
            FunctionCallResult functionCallResult = checkPluginUseEntity.getFunctionCallResult();
            if (functionCallResult != null && functionCallResult.isNeed()) {
                FunctionCall functionCall = functionCallResult.getFunctionCall();
                if ("web_search".equals(functionCall.getName())) {
                    AbstractFunctionResult<List<WebSearchFunctionResult>> functionResult = webSearchFunction.doFunction(functionCall.getArguments(), callEntity.getDialoguesId(), null, null);
                    if (functionResult != null && CollectionUtils.isNotEmpty(functionResult.getFunctionResult())) {
                        List<WebSearchFunctionResult> webSearchFunctionResults = functionResult.getFunctionResult();
                        if (CollectionUtils.isNotEmpty(webSearchFunctionResults)) {
                            toolFunction = new ToolFunction();
                            toolFunction.setResult(JsonUtils.serialize(webSearchFunctionResults));
                            toolFunction.setName("web_search");
                            toolFunction.setArguments(functionCall.getArguments());
                            toolFunction.setDisplayFormat("json");
                            LargeModelDemandResult result = new LargeModelDemandResult();
                            result.setCode("0");
                            result.setFunction(toolFunction);
                            result.setDbChainResult(null);
                            result.setKnowledgeContentResult(null);
                            sseUtil.send(JsonUtils.serialize(result));
                        }
                    }
                }
            }
        }

        //组装请求参数
        List<Message> messages = buildMessages(callEntity.getDialoguesId(), userId, callEntity.getInput(), callEntity.getFileUrl(), knowledgeResult, toolFunction);
        LargeModelResponse largeModelResponse = new LargeModelResponse();
        largeModelResponse.setModel(callEntity.getEnableDeepThinking() ? "deepseek-chat" : "deepseek-v3");//获取模型);
        largeModelResponse.setMessages(messages.toArray(new Message[0]));
        largeModelResponse.setStream(true);
        BufferedReader bufferedReader = llmService.chatChunk(largeModelResponse);
        LongtextDialoguesResult longtextDialoguesResult = textOutputStream(sseUtil, bufferedReader);


        // 保存用户输入记录
        BizAgentApplicationDialoguesRecordEntity inputRecord = new BizAgentApplicationDialoguesRecordEntity();
        inputRecord.setMemberId(userId);
        inputRecord.setContent(callEntity.getInput());
        inputRecord.setDialogsId(callEntity.getDialoguesId());
        inputRecord.setRole(LLMRoleEnum.USER.getRole());
        inputRecord.setTimestamp(inputTimestamp);

        // 保存AI回复记录
        BizAgentApplicationDialoguesRecordEntity assistantRecord = new BizAgentApplicationDialoguesRecordEntity();
        assistantRecord.setMemberId(userId);
        assistantRecord.setContent(longtextDialoguesResult.getMessage());
        assistantRecord.setReasoningContent(longtextDialoguesResult.getReasoningContent());
        assistantRecord.setDialogsId(callEntity.getDialoguesId());
        assistantRecord.setRole(LLMRoleEnum.ASSISTANT.getRole());
        assistantRecord.setTimestamp(System.currentTimeMillis());

        bizAgentApplicationDialoguesRecordService.save(inputRecord);
        bizAgentApplicationDialoguesRecordService.save(assistantRecord);
    }


    private List<Message> buildMessages(String dialogsId, Long userId, String input, String fileUrl, List<KnowledgeContentResult> knowledgeContentResults, ToolFunction toolFunction) throws Exception {
        // 获取对话提示词
        String promptCode = "AiPortalPrompt";
        BizAgentApplicationGcConfigEntity documentDialoguePrompt = bizAgentApplicationGcConfigService.getByConfigCode(promptCode);
        if (documentDialoguePrompt == null || StringUtils.isBlank(documentDialoguePrompt.getConfigSystem())) {
            logger.error("获取对话提示词失败 , configCode:{}", promptCode);
            throw new BusinessException("获取对话提示词失败");
        }

        // 加载文件
        String fileContent = StringUtils.EMPTY;
        if (StringUtils.isNoneBlank(fileUrl)) {
            File file = DocumentLoad.downloadURLDocument(fileUrl);
            fileContent = DocumentLoad.documentToText(file);
        }

        // 加载对话提示词
        String prompt = documentDialoguePrompt.getConfigSystem();
        if (CollectionUtils.isNotEmpty(knowledgeContentResults)) {
            String knowledgeContent = JsonUtils.serialize(knowledgeContentResults);
            prompt = prompt.replace("${knowledgeContent}", knowledgeContent);
         } else {
            prompt = prompt.replace("${knowledgeContent}", StringUtils.EMPTY);
        }
        if (toolFunction != null) {
            prompt = prompt.replace("${toolFunction}", JsonUtils.serialize(toolFunction));
        }

        prompt = prompt.replace("${question}", input).replace("${fileContent}", fileContent);

        // 配置message
        List<Message> messages = new ArrayList<>();
        Message systemMessage = new Message();
        systemMessage.setContent(prompt);
        systemMessage.setRole(LLMRoleEnum.SYSTEM.getRole());
        messages.add(systemMessage);

        // 对话记录
        BizAgentApplicationDialoguesRecordEntity recordEntity = new BizAgentApplicationDialoguesRecordEntity();
        recordEntity.setDialogsId(dialogsId);
        recordEntity.setIsDeleted(CommonConstant.IsDeleted.N);
        recordEntity.setMemberId(userId);
        List<BizAgentApplicationDialoguesRecordEntity> recordEntities = bizAgentApplicationDialoguesRecordService.findByExample(recordEntity, null);
        if (CollectionUtils.isNotEmpty(recordEntities)) {
            for (BizAgentApplicationDialoguesRecordEntity entity : recordEntities) {
                Message message = new Message();
                message.setContent(entity.getContent());
                message.setRole(entity.getRole());
                messages.add(message);
            }
        }
        //判断最后是否为User，若是则删除。
        if (CollectionUtils.isNotEmpty(messages)) {
            if (LLMRoleEnum.USER.getRole().equals(messages.get(messages.size() - 1).getRole())) {
                Long recordId = recordEntities.get(recordEntities.size() - 1).getId();
                bizAgentApplicationDialoguesRecordService.deletedById(recordId);
                messages.remove(messages.size() - 1);
            }
        }

        // 用户输入
        Message message = new Message();
        message.setContent(input);
        message.setRole(LLMRoleEnum.USER.getRole());
        messages.add(message);
        logger.info("--------- Build Messages dialogsId:{},messages:{}--------------", dialogsId, messages);
        return messages;
    }


    private List<KnowledgeContentResult> knowledge(List<Integer> kdIds, String input, Integer topK, Double score, KnowledgeSearchTypeEnum searchTypeEnum) {
        List<KnowledgeContentResult> knowledgeContentResults = new ArrayList<>();
        if (CollectionUtils.isEmpty(kdIds)) {
            return knowledgeContentResults;
        }
        List<String> knowledgeIds = new ArrayList<>();
        for (Integer kdId : kdIds) {
            BizKnowledgeDocumentEntity knowledgeDocumentEntity = bizKnowledgeDocumentService.get(kdId);
            // 筛选训练完成的文档，否则跳过该文档
            if (null == knowledgeDocumentEntity && KnowledgeConstant.TrainStatus.COMPLETE.equals(knowledgeDocumentEntity.getTrainStatus())) {
                continue;
            }
            knowledgeIds.add(knowledgeDocumentEntity.getKnowledgeId());
        }

        SearchKnowledgeResult searchKnowledgeResult = demandKnowledgeService.searchKnowledge(input, knowledgeIds, topK, score, searchTypeEnum);

        if (CollectionUtils.isNotEmpty(searchKnowledgeResult.getDocuments())) {
            for (int i = 1; i <= searchKnowledgeResult.getDocuments().size(); i++) {
                KnowledgeContentResult knowledgeContentResult = new KnowledgeContentResult();
                knowledgeContentResult.setContent(searchKnowledgeResult.getDocuments().get(i - 1));
                knowledgeContentResult.setKnowledgeId(searchKnowledgeResult.getKnowledgeIds().get(i - 1));
                knowledgeContentResult.setScore(searchKnowledgeResult.getScore().get(i - 1));
                knowledgeContentResults.add(knowledgeContentResult);
            }
            // 根据knowledgeId获取知识库名和文档名
            knowledgeIds = knowledgeContentResults.stream().map(KnowledgeContentResult::getKnowledgeId).distinct().collect(Collectors.toList());
            List<KnowledgeDocumentRelationQueryItem> knowledgeDocumentRelationQueryItems = bizKnowledgeDocumentService.knowledgeDocumentRelationQuery(knowledgeIds, null);
            for (KnowledgeContentResult result : knowledgeContentResults) {
                String knowledgeId = result.getKnowledgeId();
                KnowledgeDocumentRelationQueryItem item = knowledgeDocumentRelationQueryItems.stream().filter(v -> v.getKnowledgeId().equals(knowledgeId)).findFirst().get();
                result.setKnowledgeName(item.getKnowledgeName());
                result.setKdId(item.getKdId());
                result.setDocumentName(item.getDocumentName());
            }
        }

        return knowledgeContentResults;
    }


    /**
     * 文本输出结果
     *
     * @param sseUtil
     * @param bufferedReader
     * @throws IOException
     */
    private LongtextDialoguesResult textOutputStream(SSEUtil sseUtil, BufferedReader bufferedReader) throws IOException {
        String res = "";
        StringBuilder output = new StringBuilder();
        StringBuilder reasoningContent = new StringBuilder();
        try {
            while ((res = bufferedReader.readLine()) != null) {
                if (StringUtils.isEmpty(res)) {
                    continue;
                }
                res = StringUtils.replace(res, "data: ", StringUtils.EMPTY);
                LargeModelDemandResult result = JsonUtils.deSerialize(res, LargeModelDemandResult.class);
                if (!"0".equals(result.getCode())) {
                    logger.error("LLM Error,code:{}", result.getCode());
                    BusinessException ex = new BusinessException("exception/call.failure");
                    result.setMessage(ex.getMessage());
                    sseUtil.send(JsonUtils.serialize(result));
                    sseUtil.send("[DONE]");
                    sseUtil.complete();
                    throw ex;
                }
                result.setFunction(null);
                result.setDbChainResult(null);
                result.setKnowledgeContentResult(null);
                sseUtil.send(JsonUtils.serialize(result));
                if (StringUtils.isNotEmpty(result.getMessage())) {
                    output.append(result.getMessage());
                }
                if (StringUtils.isNotEmpty(result.getReasoningContent())) {
                    reasoningContent.append(result.getReasoningContent());
                }
            }
            // 关闭资源
            sseUtil.send("[DONE]");
            sseUtil.complete();
            LongtextDialoguesResult longtextDialoguesResult = new LongtextDialoguesResult();
            longtextDialoguesResult.setMessage(output.toString());
            longtextDialoguesResult.setReasoningContent(reasoningContent.toString());
            return longtextDialoguesResult;
        } catch (IOException e) {
            logger.error("连接断开,code:{}", e.getMessage());
            sseUtil.completeByError("连接断开");
            throw new BusinessException("连接断开");
        } finally {
            bufferedReader.close();
            sseUtil.complete();
        }
    }

    private ToolFunction functionResultConvertToolFunction(FunctionResult functionResult) {
        ToolFunction toolFunction = new ToolFunction();
        BizAgentApplicationPluginEntity bizAgentApplicationPluginEntity = bizAgentApplicationPluginService.getInfoByPluginId(functionResult.getFunctionName());
        if (bizAgentApplicationPluginEntity != null && !bizAgentApplicationPluginEntity.getClassification().equals("system")) {
            String lang = BlContext.getCurrentLocaleLanguageToLowerCase();
            switch (lang) {
                case ZH_CN:
                    toolFunction.setName(bizAgentApplicationPluginEntity.getZhCnTitle());
                    break;
                case ZH_TW:
                    toolFunction.setName(bizAgentApplicationPluginEntity.getZhTwTitle());
                    break;
                case EN:
                    toolFunction.setName(bizAgentApplicationPluginEntity.getEnTitle());
                    break;
            }
            toolFunction.setDisplayFormat(bizAgentApplicationPluginEntity.getDisplayFormat());
        }
        toolFunction.setArguments(functionResult.getFunctionArg());
        String functionResultStr = functionResult.getFunctionResult() instanceof String ? String.valueOf(functionResult.getFunctionResult()) : JsonUtils.serialize(functionResult.getFunctionResult());
        toolFunction.setResult(functionResultStr);
        return toolFunction;
    }
}
