package cn.com.poc.thirdparty.resource.baidu.constants;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public interface BaiduTransTypeConstants {

    String SIMPLIFIED_CHINESE = "zh"; // 简体中文

    String TRADITIONAL_CHINESE = "cht"; // 繁体中文

    String CANTONESE = "yue"; // 粤语

    String ENGLISH = "en"; // 英语

    // 工具类
    class Utils {
        private static Set<String> CONSTANTS = new HashSet<>();

        static {
            CONSTANTS.add(SIMPLIFIED_CHINESE);
            CONSTANTS.add(TRADITIONAL_CHINESE);
            CONSTANTS.add(CANTONESE);
            CONSTANTS.add(ENGLISH);
            CONSTANTS = Collections.unmodifiableSet(CONSTANTS);
        }

        public static boolean isExist(String value) {
            return CONSTANTS.contains(value);
        }
    }

}
