package cn.com.poc.thirdparty.resource.baidu.entity.response;

import org.springframework.web.multipart.MultipartFile;

import java.io.File;

/**
 * @author alex.yao
 * @date 2025/6/25
 */
public class BaiduTextDiffResponse {

    /**
     * 文件数据，主版比对文档
     * 支持的文件类型：
     * -图片：bmp/jpg/jpeg/png/tif/tiff
     * -文档：doc/docx/wps/pdf/ofd
     * 支持的文件大小：仅支持上传一篇文件，文件大小不超过10M。图像最短边至少15px，最长边最大4096px
     * 优先级： baseFile > baseFileURL，当baseFile字段存在时，baseFileURL字段失效
     */
    private File baseFile;

    /**
     * 文件数据，副版比对文档
     * 支持的文件类型：
     * -图片：bmp/jpg/jpeg/png/tif/tiff
     * -文档：doc/docx/wps/pdf/ofd
     * 支持的文件大小：仅支持上传一篇文件，文件大小不超过10M。图像最短边至少15px，最长边最大4096px
     * 优先级： compareFile > compareFileURL，当compareFile字段存在时，compareFileURL字段失效
     */
    private File compareFile;

    private String baseFileURL;

    private String compareFileURL;

    /**
     * 文档比对特殊差异识别参数。默认为false。将指定参数以json格式传递。例如，传递参数{"sealRecognition":true,"handWritingRecognition":true}将分别启用印章识别与手写体识别功能
     */
    private Param param;

    public File getBaseFile() {
        return baseFile;
    }

    public void setBaseFile(File baseFile) {
        this.baseFile = baseFile;
    }

    public File getCompareFile() {
        return compareFile;
    }

    public void setCompareFile(File compareFile) {
        this.compareFile = compareFile;
    }

    public String getBaseFileURL() {
        return baseFileURL;
    }

    public void setBaseFileURL(String baseFileURL) {
        this.baseFileURL = baseFileURL;
    }

    public String getCompareFileURL() {
        return compareFileURL;
    }

    public void setCompareFileURL(String compareFileURL) {
        this.compareFileURL = compareFileURL;
    }

    public Param getParam() {
        return param;
    }

    public void setParam(Param param) {
        this.param = param;
    }

    /**
     * sealRecognition	否	bool	true/false	是否识别印章信息（识别印章信息有额外的时间开销）。默认为false
     * fullWidthHalfWidthRecognition	否	bool	true/false	是否识别中英文符号差异。默认为false
     * fontFamilyRecognition	否	bool	true/false	是否识别字体差异。默认为false
     * fontSizeRecognition	否	bool	true/false	是否识别字号差异。默认为false
     * handWritingRecognition  否	bool	true/false	是否识别手写体信息。默认为false
     */
    public static class Param {
        private Boolean sealRecognition;
        private Boolean fullWidthHalfWidthRecognition;
        private Boolean fontFamilyRecognition;
        private Boolean fontSizeRecognition;
        private Boolean handWritingRecognition;

        public Boolean getSealRecognition() {
            return sealRecognition;
        }

        public void setSealRecognition(Boolean sealRecognition) {
            this.sealRecognition = sealRecognition;
        }

        public Boolean getFullWidthHalfWidthRecognition() {
            return fullWidthHalfWidthRecognition;
        }

        public void setFullWidthHalfWidthRecognition(Boolean fullWidthHalfWidthRecognition) {
            this.fullWidthHalfWidthRecognition = fullWidthHalfWidthRecognition;
        }

        public Boolean getFontFamilyRecognition() {
            return fontFamilyRecognition;
        }

        public void setFontFamilyRecognition(Boolean fontFamilyRecognition) {
            this.fontFamilyRecognition = fontFamilyRecognition;
        }

        public Boolean getFontSizeRecognition() {
            return fontSizeRecognition;
        }

        public void setFontSizeRecognition(Boolean fontSizeRecognition) {
            this.fontSizeRecognition = fontSizeRecognition;
        }

        public Boolean getHandWritingRecognition() {
            return handWritingRecognition;
        }

        public void setHandWritingRecognition(Boolean handWritingRecognition) {
            this.handWritingRecognition = handWritingRecognition;
        }
    }
}


