package cn.com.poc.thirdparty.resource.baidu.entity.result;

import java.io.File;

/**
 * @Author：Roger Wu
 * @name：TextReviewRequest
 * @Date：2025-05-29 17:15
 */
public class TextReviewRequest {

    /**
     * 文件数据，支持Word和PDF格式，文件大小不超过10M
     * 优先级： file > fileURLList，当file字段存在时，fileURLList字段失效
     */
    private File file;

    /**
     * 文件完整URL，仅支持北京区域的BOS公网访问，URL长度不超过1024字节，支持PDF/doc/docx格式，仅支持上传1篇文件，文件大小不超过10M
     * 优先级： file > fileURLList，当file字段存在时，fileURLList字段失效
     * 请注意关闭URL防盗链
     */
    private String fileURLList;

    /**
     * 该清单类型为系统预置清单。每次审查任务仅可选择单一清单。具体清单选项如下：
     * - Sales_PartyA_V2：买卖合同-买方；
     * - Sales_PartyB_V2：买卖合同-卖方；
     * - Lease_PartyA_V2：租赁合同-出租方；
     * - Lease_PartyB_V2：租赁合同-承租方；
     * - TechDev_PartyA_V2：技术开发合同-委托方；
     * - TechDev_PartyB_V2：技术开发合同-受托方；
     * - Labor_PartyA_V2：劳动合同-用人单位；
     * - Labor_PartyB_V2：劳动合同-劳动者；
     * - Entrustment_PartyA_V2：委托合同-委托方；
     * - Entrustment_PartyB_V2：委托合同-受托方；
     * - Work-for-hire_PartyA_V2：承揽合同-定作人；
     * - Work-for-hire_PartyB_V2：承揽合同-承揽人；
     * - LaborDispatch_PartyA_V2：劳务派遣合同-用工单位；
     * - LaborDispatch_PartyB_V2：劳务派遣合同-劳务派遣单位；
     * - RealtySvcs_PartyA_V2：物业服务合同-业主；
     * - RealtySvcs_PartyB_V2：物业服务合同-物业服务人；
     * - EquipPur_PartyA_V2：设备采购合同-买方；
     * - EquipPur_PartyB_V2：设备采购合同-卖方；
     * - FinLease_PartyA_V2：融资租赁合同-出租方；
     * - FinLease_PartyB_V2：融资租赁合同-承租方；
     * - DebtAssign_PartyA_V2：债权转让合同-转让方；
     * - DebtAssign_PartyB_V2：债权转让合同-受让方；
     * - CISG_PartyA_V2：国际货物贸易合同-买方；
     * - CISG_PartyB_V2：国际货物贸易合同-卖方 ；
     * - GUAR_PartyA_V2：保证合同-保证方 ；
     * - GUAR_PartyA_V2：保证合同-债权方 ；
     * - CG_PartyA_V2：货运合同-承运方 ；
     * - CG_PartyB_V2：货运合同-托运方 ；
     * - Factoring_PartyA_V2：保理合同-保理商 ；
     * - Factoring_PartyB_V2：保理合同-卖方 ；
     * - Brokerage_PartyA_V2：中介合同-委托人 ；
     * - Brokerage_PartyB_V2：中介合同-中介人 ；
     * - TradingTrust_PartyA_V2：行纪合同-委托人 ；
     * - TradingTrust_PartyB_V2：行纪合同-行纪人 ；
     * - PNRship_V2：合伙合同-合伙人 ；
     * - PT/PAT_PartyA_V2：专利（申请）权转让合同-受让方 ；
     * - PT/PAT_PartyB_V2：专利（申请）权转让合同-转让方；
     * - TST_PartyA_V2：技术秘密转让合同-受让方；
     * - TST_PartyB_V2：技术秘密转让合同-转让方；
     * - TST_PartyB_V2：技术秘密转让合同-转让方；
     * -TechLic_PartyA_V2：技术许可合同-许可方；
     * -TechLic_PartyB_V2：技术许可合同-被许可方；
     * - EquipLea_PartyA_V2：设备租赁合同-出租方；
     * - EquipLea_PartyB_V2：设备租赁合同-承租方；
     * - ConstCtrl_PartyA_V2：建设工程施工合同-发包方；
     * - ConstCtrl_PartyB_V2：建设工程施工合同-承包方
     */
    private String templateName;

    /**
     * 该清单类型为用户在合同审查清单管理 创建的我的清单。每次审查任务仅可选择单一清单
     * https://ai.baidu.com/ai-doc/OCR/olqc085rg
     */
    private String templateId;

    /**
     * 筛选下载的批注结果中展示的风险等级条款。默认为"major"，即仅展示重大风险条款。
     * - normal：一般风险；
     * - major：重大风险；
     * - all：一般风险和重大风险
     */
    private String commentRiskLevel;

    public File getFile() {
        return file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getFileURLList() {
        return fileURLList;
    }

    public void setFileURLList(String fileURLList) {
        this.fileURLList = fileURLList;
    }

    public String getTemplateName() {
        return templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public String getTemplateId() {
        return templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public String getCommentRiskLevel() {
        return commentRiskLevel;
    }

    public void setCommentRiskLevel(String commentRiskLevel) {
        this.commentRiskLevel = commentRiskLevel;
    }
}
