package cn.com.poc.thirdparty.resource.baidu.service;

import cn.com.poc.thirdparty.resource.baidu.entity.response.BaiduTextDiffResponse;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;

/**
 * @author alex.yao
 * @date 2025/6/25
 */
public interface BaiduTextDiffService {

    /**
     * 文档比对任务创建接口
     *
     * @param baseFile    主版比对文档
     * @param compareFile 副版比对文档
     * @param param       参数
     * @return taskId - 任务ID
     */
    String textDiff(File baseFile, File compareFile, BaiduTextDiffResponse.Param param, Long userId);

    /**
     * 文档比对任务创建接口
     *
     * @param baseFileUrl    主版比对文档URL
     * @param compareFileUrl 副版比对文档URL
     * @param param          参数
     * @return taskId - 任务ID
     */
    String textDiff(String baseFileUrl, String compareFileUrl, BaiduTextDiffResponse.Param param, Long userId);

    /**
     * 查询文档比对任务结果
     *
     * @param taskId 任务ID
     * @return 文档比对任务结果
     */
    String queryTextDiffTask(String taskId) throws Exception;

    /**
     * 获取前端SDK渲染
     *
     * @param taskId 任务ID
     * @return SDK渲染地址
     */
    String getSDKUrl(String taskId);


}
