package cn.com.poc.thirdparty.resource.demand.ai.aggregate;


import cn.com.poc.thirdparty.resource.demand.ai.entity.csvchain.CSVChainResponse;
import cn.com.poc.thirdparty.resource.demand.ai.entity.csvchain.CSVChainResult;
import cn.com.poc.thirdparty.resource.demand.ai.entity.dbchain.DBChainResponse;
import cn.com.poc.thirdparty.resource.demand.ai.entity.dbchain.DBChainResult;
import cn.com.poc.thirdparty.resource.demand.ai.entity.function.FunctionCallResponse;
import cn.com.poc.thirdparty.resource.demand.ai.entity.function.FunctionCallResult;
import cn.com.poc.thirdparty.resource.demand.ai.entity.largemodel.LargeModelDemandResult;
import cn.com.poc.thirdparty.resource.demand.ai.entity.largemodel.LargeModelResponse;
import cn.com.poc.thirdparty.resource.demand.ai.entity.legal.LegalFileResponse;
import cn.com.poc.thirdparty.resource.demand.ai.entity.legal.LegalFileResult;

import java.io.BufferedReader;

/**
 * @author alex.yao
 * @date 2023/5/24
 * <p>
 * AI 对话
 **/
public interface AIDialogueService {

    /**
     * 调用中台通用大模型接口 [流]
     */
    BufferedReader polyStream(LargeModelResponse largeResponse) throws Exception;


    /**
     * 调用中台通用大模型接口 [非流]
     */
    LargeModelDemandResult poly(LargeModelResponse largeResponse);


    /**
     * 判断是否需要Function Call
     */
    FunctionCallResult functionCall(FunctionCallResponse response);


    /**
     * 调用DB_CHAIN 接口
     */
    DBChainResult dbChain(DBChainResponse response);

    /**
     * 调用CSV_CHAIN 接口
     */
    CSVChainResult csvChain(CSVChainResponse response);

}
