package cn.com.poc.thirdparty.resource.demand.ai.aggregate;

import cn.com.poc.thirdparty.resource.demand.ai.constants.KnowledgeSearchTypeEnum;
import cn.com.poc.thirdparty.resource.demand.ai.entity.knowledge.GetKnowledgeChunkInfoResult;
import cn.com.poc.thirdparty.resource.demand.ai.entity.knowledge.SearchKnowledgeResult;
import cn.com.poc.thirdparty.resource.demand.ai.entity.knowledge.SegmentationConfigRequest;
import cn.com.poc.thirdparty.resource.demand.ai.entity.qaknowledge.QAKnowledgeConfig;
import cn.com.yict.framemax.data.model.PagingInfo;

import java.util.List;

/**
 * 知识库
 */
public interface DemandKnowledgeService {

    /**
     * 训练知识库
     *
     * @param fileURL 训练文档
     * @return 知识库id
     */
    String trainKnowledge(String fileURL, SegmentationConfigRequest segmentationConfig);

    /**
     * 训练知识库-异步
     *
     * @param fileURL 训练文档
     * @return 知识库id
     */
    String trainKnowledgeEvent(String fileURL, String knowledgeType, SegmentationConfigRequest segmentationConfig, List<QAKnowledgeConfig> qaKnowledgeConfigs);

    /**
     * 获取知识库训练状态
     *
     * @param knowledgeId
     * @return 训练状态
     */
    String trainKnowledgeStatus(String knowledgeId);

    /**
     * 删除知识库
     *
     * @param knowledgeId 知识库id
     */
    void delKnowledge(String knowledgeId);

    /**
     * 知识库查询
     *
     * @param query          查询文本
     * @param knowledgeIds   知识库id
     * @param topK           返回个数
     * @param score          分数阈值
     * @param searchTypeEnum 查询类型
     * @return 查询结果
     */
    SearchKnowledgeResult searchKnowledge(String query, List<String> knowledgeIds, Integer topK, Double score, KnowledgeSearchTypeEnum searchTypeEnum);

    /**
     * 获取知识库分片
     *
     * @param knowledgeIds 知识库id
     * @param query        查询文本
     * @param pagingInfo   分页信息
     */
    GetKnowledgeChunkInfoResult getKnowledgeChunkInfos(List<String> knowledgeIds, String query, PagingInfo pagingInfo);

    /**
     * 开关知识库分片
     *
     * @param knowledgeId     知识库id
     * @param chunkRelationId 分片关系id
     * @param isOpen          是否开启 Y/N
     */
    void openKnowledgeChunk(String knowledgeId, String chunkRelationId, String isOpen);

    /**
     * 删除知识库分片
     *
     * @param knowledgeId     知识库id
     * @param chunkRelationId 分片关系id
     */
    void deleteKnowledgeChunk(String knowledgeId, String chunkRelationId);

    /**
     * 更新知识库分片内容
     *
     * @param knowledgeId     知识库id
     * @param chunkRelationId 分片关系id
     * @param content         分片内容
     */
    void updateKnowledgeChunkDoc(String knowledgeId, String chunkRelationId, String content);

    /**
     * 新增知识库分片
     *
     * @param knowledgeId 知识库id
     * @param content     分片内容
     * @param chunkSort   分片排序
     */
    void addKnowledgeChunk(String knowledgeId, String content, Integer chunkSort);

}
