package cn.com.poc.thirdparty.resource.demand.ai.aggregate.impl;

import cn.com.poc.thirdparty.resource.demand.ai.aggregate.LegalService;
import cn.com.poc.thirdparty.resource.demand.ai.entity.legal.LegalFileResponse;
import cn.com.poc.thirdparty.resource.demand.ai.entity.legal.LegalFileResult;
import cn.com.poc.thirdparty.resource.demand.ai.route.DgtoolsApiRoute;
import cn.com.poc.thirdparty.resource.demand.dgTools.DgtoolsAbstractHttpClient;
import cn.com.poc.thirdparty.resource.demand.member.service.DemandAuthService;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * @author alex.yao
 * @date 2025/7/28
 */
@Service
public class LegalServiceImpl implements LegalService {

    @Resource
    private DgtoolsAbstractHttpClient dgToolsAbstractHttpClient;

    @Resource
    private DemandAuthService demandAuthService;

    @Override
    public LegalFileResult legalFile(LegalFileResponse response) {
        String url = DgtoolsApiRoute.DgtoolsAI.LEGAL_FILE;
        List<Header> headers = new ArrayList<Header>() {{
            add(DgtoolsApiRoute.JSON_HEADER);
            add(DgtoolsApiRoute.AI_HEADER);
            add(new BasicHeader(DgtoolsApiRoute.HEADER_X_PLATFORM_AUTHORIZATION, demandAuthService.getToken()));
        }};
        return dgToolsAbstractHttpClient.doRequest(url, response, headers);
    }
}
