package cn.com.poc.thirdparty.resource.demand.ai.function;


import cn.com.poc.agent_application.entity.KnowledgeContentResult;
import cn.com.poc.agent_application.entity.Variable;
import cn.com.poc.thirdparty.resource.demand.ai.entity.dbchain.DBChainResult;

import java.util.List;

public abstract class AbstractLargeModelFunction {

    /**
     * 执行函数
     *
     * @param content                 入参
     * @param identifier              唯一标识
     * @param dbChainResults
     * @param knowledgeContentResults
     * @return
     */
    public abstract AbstractFunctionResult doFunction(String content, String identifier, List<DBChainResult> dbChainResults, List<KnowledgeContentResult> knowledgeContentResults);

    /**
     * 获取函数描述
     *
     * @return
     */
    public abstract String getDesc();

    /**
     * 获取配置
     */
    public abstract List<String> getLLMConfig();


    /**
     * 获取有关变量的配置
     */
    public abstract List<String> getLLMConfig(List<Variable> variableStructure);


}
