package cn.com.poc.thirdparty.resource.demand.ai.function.csv_data_analysis;

import cn.com.poc.agent_application.entity.KnowledgeContentResult;
import cn.com.poc.agent_application.entity.Variable;
import cn.com.poc.common.utils.JsonUtils;
import cn.com.poc.thirdparty.resource.demand.ai.entity.csvchain.CSVChainResponse;
import cn.com.poc.thirdparty.resource.demand.ai.entity.csvchain.CSVChainResult;
import cn.com.poc.thirdparty.resource.demand.ai.entity.dbchain.DBChainResult;
import cn.com.poc.thirdparty.resource.demand.ai.function.AbstractFunctionResult;
import cn.com.poc.thirdparty.resource.demand.ai.function.AbstractLargeModelFunction;
import cn.com.poc.thirdparty.resource.demand.ai.function.chart_generate.ChartGenerateFunction;
import cn.com.poc.thirdparty.resource.demand.ai.function.entity.FunctionLLMConfig;
import cn.com.poc.thirdparty.resource.demand.ai.function.entity.Parameters;
import cn.com.poc.thirdparty.resource.demand.ai.function.entity.Properties;
import cn.com.poc.thirdparty.service.ChainService;
import cn.hutool.core.collection.ListUtil;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author alex.yao
 * @date 2025/6/20
 */
@Component
public class CSVFunction extends AbstractLargeModelFunction {
    private final Logger logger = LoggerFactory.getLogger(ChartGenerateFunction.class);

    private final String DESC = "解析用户上传的CSV或Excel文件，并使用Python库pands对其进行分析，根据用户问题返回数据";

    private final FunctionLLMConfig functionLLMConfig = new FunctionLLMConfig.FunctionLLMConfigBuilder()
            .name("csv_data_analysis")
            .description(DESC)
            .parameters(new Parameters("object")
                    .addProperties("question", new Properties("string", "对用户问题优化后的问题"))
                    .addProperties("file_url", new Properties("string", "文件真实地址"))
            )
            .build();


    @Value(value = "${large-model.apikey}")
    private String API_KEY;

    @Resource
    private ChainService chainService;

    @Override
    public AbstractFunctionResult<String> doFunction(String content, String identifier, List<DBChainResult> dbChainResults, List<KnowledgeContentResult> knowledgeContentResults) {
        AbstractFunctionResult<String> result = new AbstractFunctionResult<>();
        JSONObject jsonObject = JSONObject.parseObject(content);
        if (!jsonObject.containsKey("file_url") || !jsonObject.containsKey("question")) {
            logger.error("缺少必要参数,content:{}", content);
            return result;
        }
        CSVChainResponse csvChainResponse = new CSVChainResponse();
        csvChainResponse.setQuestion(jsonObject.getString("question"));
        csvChainResponse.setFilePath(jsonObject.getString("file_url"));
        csvChainResponse.setApiKey(API_KEY);
        CSVChainResult csvChainResult = chainService.csvChain(csvChainResponse);
        if (csvChainResult == null || csvChainResult.getResult() == null || "error".equals(csvChainResult.getStatus())) {
            logger.error("csvChainResult is null,csvChainResult:{}", csvChainResult);
            return result;
        }
        result.setFunctionResult(csvChainResult.getResult());
        result.setPromptContent(csvChainResult.getResult());
        return result;
    }

    @Override
    public String getDesc() {
        return DESC;
    }

    @Override
    public List<String> getLLMConfig() {
        return ListUtil.toList(JsonUtils.serialize(functionLLMConfig));
    }

    @Override
    public List<String> getLLMConfig(List<Variable> variableStructure) {
        return this.getLLMConfig();
    }
}
