package cn.com.poc.thirdparty.resource.demand.ai.function.notification_reminder;

import cn.com.poc.agent_application.entity.KnowledgeContentResult;
import cn.com.poc.agent_application.entity.Variable;
import cn.com.poc.common.service.RedisService;
import cn.com.poc.common.utils.*;
import cn.com.poc.support.security.oauth.entity.UserBaseEntity;
import cn.com.poc.thirdparty.resource.demand.ai.entity.dbchain.DBChainResult;
import cn.com.poc.thirdparty.resource.demand.ai.function.AbstractFunctionResult;
import cn.com.poc.thirdparty.resource.demand.ai.function.AbstractLargeModelFunction;
import cn.com.poc.thirdparty.resource.demand.ai.function.entity.FunctionLLMConfig;
import cn.com.poc.thirdparty.resource.demand.ai.function.entity.Parameters;
import cn.com.poc.thirdparty.resource.demand.ai.function.entity.Properties;
import cn.com.poc.user.entity.MemberInfoEntity;
import cn.com.poc.user.service.BizMemberInfoService;
import cn.hutool.core.collection.ListUtil;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

/**
 * @author alex.yao
 * @date 2025/1/16
 */
@Component
public class NotificationReminderFunction extends AbstractLargeModelFunction {

    private final String DESC = "该方法是通过建立定时任务，向用户推送用户设定的提醒内容。现在的日期时间是：";

    @Resource
    private RedisService redisService;

    @Resource
    private BizMemberInfoService bizMemberInfoService;

    private FunctionLLMConfig functionLLMConfig;

    @Override
    public AbstractFunctionResult<String> doFunction(String content, String identifier, List<DBChainResult> dbChainResults, List<KnowledgeContentResult> knowledgeContentResults) {
        AbstractFunctionResult<String> result = new AbstractFunctionResult<>();
        UserBaseEntity userBaseEntity = BlContext.getCurrentUserNotException();
        if (userBaseEntity == null) {
            result.setFunctionResult("FAIL");
            result.setPromptContent("FAIL");
            return result;
        }
        try {
            MemberInfoEntity memberInfoEntity = bizMemberInfoService.getById(userBaseEntity.getUserId().intValue());
            String email = memberInfoEntity.getEmail();
            if (StringUtils.isBlank(email)) {
                result.setFunctionResult("Error 【执行失败】: 用户需要完善个人邮箱信息后再使用。");
                result.setPromptContent("Error 【执行失败】: 用户需要完善个人邮箱信息后再使用。");
                return result;
            }
            JSONObject jsonObject = JSONObject.parseObject(content);
            jsonObject.put("email", email);
            jsonObject.put("sign", UUIDTool.getUUID());
            Date date = jsonObject.getDate("datetime");
            if (date.before(DateUtils.getCurrDateTime())) {
                result.setFunctionResult("Error 【执行失败】: 通知的日期时间已经超过当前时间。");
                result.setPromptContent("Error 【执行失败】: 通知的日期时间已经超过当前时间。");
                return result;
            }
            long expiredTime = DateUtils.diffTwoDate(date, DateUtils.getCurrDateTime()) / 1000;
            redisService.set(NotificationReminderConstant.REDIS_KEY + jsonObject.toJSONString(), null, expiredTime);

            result.setFunctionResult("SUCCESS");
            result.setPromptContent("SUCCESS");
            return result;
        } catch (Exception e) {
            result.setFunctionResult("FAIL");
            result.setPromptContent("FAIL");
            return result;
        }
    }

    @Override
    public String getDesc() {
        return DESC;
    }

    @Override
    public List<String> getLLMConfig() {
        functionLLMConfig = new FunctionLLMConfig
                .FunctionLLMConfigBuilder()
                .name("notification_reminder")
                .description(DESC + DateUtils.formatDate(DateUtils.getCurrDateTime(), DateUtils.yyyy_MM_dd_HH_mm_ss))
                .parameters(new Parameters("object")
                        .addProperties("content", new Properties("string", "提醒内容"))
                        .addProperties("datetime", new Properties("date", "任务执行的日期时间"))
                ).build();
        return ListUtil.toList(JsonUtils.serialize(functionLLMConfig));
    }

    @Override
    public List<String> getLLMConfig(List<Variable> variableStructure) {
        return getLLMConfig();
    }
}
