package cn.com.poc.thirdparty.resource.demand.member.api;

import cn.com.poc.thirdparty.resource.demand.member.entity.DemandAuthResponse;
import cn.com.poc.thirdparty.resource.demand.member.entity.DemandAuthResult;
import cn.com.poc.thirdparty.resource.demand.dgTools.DgtoolsAbstractHttpClient;
import cn.com.poc.thirdparty.resource.demand.ai.route.DgtoolsApiRoute;
import org.apache.http.Header;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.LinkedList;
import java.util.List;

/**
 * @author alex.yao
 * @date 2023/5/17
 **/
@Service
public class DemandAuthApi {

    @Resource
    private DgtoolsAbstractHttpClient dgToolsAbstractHttpClient;

    /**
     * 获取中台token
     * @param response
     * @return
     */
    public DemandAuthResult getToken(DemandAuthResponse response) {
        List<Header> headers = new LinkedList<>();
        headers.add(DgtoolsApiRoute.MEMBER_HEADER);
        return dgToolsAbstractHttpClient.doRequest(DgtoolsApiRoute.MemberPlatform.GET_PLATFORM_TOKEN, response, headers);
    }
}
