package cn.com.poc.thirdparty.resource.demand.pay.model;

import cn.com.yict.framemax.data.model.BaseModelClass;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.io.Serializable;

/**
 * Model class for dgtools_merchant
 * 商家表
 */
@Entity
@Table(name = "dgtools_merchant")
@DynamicInsert
@DynamicUpdate
public class DgtoolsMerchantModel extends BaseModelClass implements Serializable {

    private static final long serialVersionUID = 1L;
    
  
    /** merchant_id
    *支付体系的id
    */ 
    private Integer merchantId;
    
    @Column(name = "merchant_id",length = 10)
	@Id @GeneratedValue(strategy = GenerationType.AUTO) 
    public Integer getMerchantId(){
        return this.merchantId;
    }
    
    public void setMerchantId(Integer merchantId){
        this.merchantId = merchantId;
        super.addValidField("merchantId");
    }
    
  
    /** merchant_name
    *商家名
    */ 
    private String merchantName;
    
    @Column(name = "merchant_name",length = 255)
    public String getMerchantName(){
        return this.merchantName;
    }
    
    public void setMerchantName(String merchantName){
        this.merchantName = merchantName;
        super.addValidField("merchantName");
    }
    
  
    /** acct_id
    *支付账号
    */ 
    private String acctId;
    
    @Column(name = "acct_id",length = 10)
    public String getAcctId(){
        return this.acctId;
    }
    
    public void setAcctId(String acctId){
        this.acctId = acctId;
        super.addValidField("acctId");
    }
    
  
    /** corp_info_id
    *企业号
    */ 
    private Integer corpInfoId;
    
    @Column(name = "corp_info_id",length = 10)
    public Integer getCorpInfoId(){
        return this.corpInfoId;
    }
    
    public void setCorpInfoId(Integer corpInfoId){
        this.corpInfoId = corpInfoId;
        super.addValidField("corpInfoId");
    }
    
  
    /** is_deleted
    *是否删除 1、Y 是 2、N 否
    */ 
    private String isDeleted;
    
    @Column(name = "is_deleted",length = 1)
    public String getIsDeleted(){
        return this.isDeleted;
    }
    
    public void setIsDeleted(String isDeleted){
        this.isDeleted = isDeleted;
        super.addValidField("isDeleted");
    }
    
  
    /** CREATOR
    *创建人
    */ 
    private String creator;
    
    @Column(name = "CREATOR",length = 50)
    public String getCreator(){
        return this.creator;
    }
    
    public void setCreator(String creator){
        this.creator = creator;
        super.addValidField("creator");
    }
    
  
    /** CREATED_TIME
    *创建时间
    */ 
    private java.util.Date createdTime;
    
    @Column(name = "CREATED_TIME",length = 19)
    public java.util.Date getCreatedTime(){
        return this.createdTime;
    }
    
    public void setCreatedTime(java.util.Date createdTime){
        this.createdTime = createdTime;
        super.addValidField("createdTime");
    }
    
  
    /** MODIFIER
    *修改人
    */ 
    private String modifier;
    
    @Column(name = "MODIFIER",length = 50)
    public String getModifier(){
        return this.modifier;
    }
    
    public void setModifier(String modifier){
        this.modifier = modifier;
        super.addValidField("modifier");
    }
    
  
    /** MODIFIED_TIME
    *修改时间
    */ 
    private java.util.Date modifiedTime;
    
    @Column(name = "MODIFIED_TIME",length = 19)
    public java.util.Date getModifiedTime(){
        return this.modifiedTime;
    }
    
    public void setModifiedTime(java.util.Date modifiedTime){
        this.modifiedTime = modifiedTime;
        super.addValidField("modifiedTime");
    }
    
  
    /** SYS_VERSION
    *乐观锁,版本号
    */ 
    private Integer sysVersion;
    
    @Column(name = "SYS_VERSION",length = 10)
	@Version
    public Integer getSysVersion(){
        return this.sysVersion;
    }
    
    public void setSysVersion(Integer sysVersion){
        this.sysVersion = sysVersion;
        super.addValidField("sysVersion");
    }
    

}