package cn.com.poc.thirdparty.resource.demand.pay.model;

import cn.com.yict.framemax.data.model.BaseModelClass;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.io.Serializable;

/**
 * Model class for dgtools_merchant_pay_config
 * 
 */
@Entity
@Table(name = "dgtools_merchant_pay_config")
@DynamicInsert
@DynamicUpdate
public class DgtoolsMerchantPayConfigModel extends BaseModelClass implements Serializable {

    private static final long serialVersionUID = 1L;
    
  
    /** merchant_pay_config_id
    *
    */ 
    private Integer merchantPayConfigId;
    
    @Column(name = "merchant_pay_config_id",length = 10)
	@Id @GeneratedValue(strategy = GenerationType.AUTO) 
    public Integer getMerchantPayConfigId(){
        return this.merchantPayConfigId;
    }
    
    public void setMerchantPayConfigId(Integer merchantPayConfigId){
        this.merchantPayConfigId = merchantPayConfigId;
        super.addValidField("merchantPayConfigId");
    }


    /** merchant_id
    *商家id
    */
    private Integer merchantId;

    @Column(name = "merchant_id",length = 10)
    public Integer getMerchantId(){
        return this.merchantId;
    }

    public void setMerchantId(Integer merchantId){
        this.merchantId = merchantId;
        super.addValidField("merchantId");
    }

    /**
     * corp_info_id
     * 企业号
     */
    private Integer corpInfoId;

    @Column(name = "corp_info_id",length = 10)
    public Integer getCorpInfoId() {
        return corpInfoId;
    }

    public void setCorpInfoId(Integer corpInfoId) {
        this.corpInfoId = corpInfoId;
        super.addValidField("corpInfoId");
    }


    /** pay_channel
    *支付渠道
    */ 
    private String payChannel;
    
    @Column(name = "pay_channel",length = 50)
    public String getPayChannel(){
        return this.payChannel;
    }
    
    public void setPayChannel(String payChannel){
        this.payChannel = payChannel;
        super.addValidField("payChannel");
    }
    
  
    /** merchant_config_code
    *支付code 
    */ 
    private String merchantConfigCode;
    
    @Column(name = "merchant_config_code",length = 50)
    public String getMerchantConfigCode(){
        return this.merchantConfigCode;
    }
    
    public void setMerchantConfigCode(String merchantConfigCode){
        this.merchantConfigCode = merchantConfigCode;
        super.addValidField("merchantConfigCode");
    }
    
  
    /** merchant_config_value
    *支付值
    */ 
    private String merchantConfigValue;
    
    @Column(name = "merchant_config_value",length = 50)
    public String getMerchantConfigValue(){
        return this.merchantConfigValue;
    }
    
    public void setMerchantConfigValue(String merchantConfigValue){
        this.merchantConfigValue = merchantConfigValue;
        super.addValidField("merchantConfigValue");
    }
    
  
    /** is_deleted
    *是否删除
    */ 
    private String isDeleted;
    
    @Column(name = "is_deleted",length = 1)
    public String getIsDeleted(){
        return this.isDeleted;
    }
    
    public void setIsDeleted(String isDeleted){
        this.isDeleted = isDeleted;
        super.addValidField("isDeleted");
    }
    
  
    /** CREATOR
    *创建人
    */ 
    private String creator;
    
    @Column(name = "CREATOR",length = 50)
    public String getCreator(){
        return this.creator;
    }
    
    public void setCreator(String creator){
        this.creator = creator;
        super.addValidField("creator");
    }
    
  
    /** CREATED_TIME
    *创建时间
    */ 
    private java.util.Date createdTime;
    
    @Column(name = "CREATED_TIME",length = 19)
    public java.util.Date getCreatedTime(){
        return this.createdTime;
    }
    
    public void setCreatedTime(java.util.Date createdTime){
        this.createdTime = createdTime;
        super.addValidField("createdTime");
    }
    
  
    /** MODIFIER
    *修改人
    */ 
    private String modifier;
    
    @Column(name = "MODIFIER",length = 50)
    public String getModifier(){
        return this.modifier;
    }
    
    public void setModifier(String modifier){
        this.modifier = modifier;
        super.addValidField("modifier");
    }
    
  
    /** MODIFIED_TIME
    *修改时间
    */ 
    private java.util.Date modifiedTime;
    
    @Column(name = "MODIFIED_TIME",length = 19)
    public java.util.Date getModifiedTime(){
        return this.modifiedTime;
    }
    
    public void setModifiedTime(java.util.Date modifiedTime){
        this.modifiedTime = modifiedTime;
        super.addValidField("modifiedTime");
    }
    
  
    /** SYS_VERSION
    *版本号
    */ 
    private Integer sysVersion;
    
    @Column(name = "SYS_VERSION",length = 10)
	@Version
    public Integer getSysVersion(){
        return this.sysVersion;
    }
    
    public void setSysVersion(Integer sysVersion){
        this.sysVersion = sysVersion;
        super.addValidField("sysVersion");
    }
    

}