SELECT
    po.pay_order_id,
    po.pay_order_sn,
    po.pay_order_type,
    po.total_amount,
    po.paid_amount,
    po.need_pay_amount,
    po.member_id,
    po.sharer_id,
    po.marketing_game_flow_no,
    po.currency,
    po.retain_information,
    po.description,
    po.order_status,
    po.pay_status,
    po.pay_time,
    po.cancel_time,
    po.corp_info_id,
    po.merchant_id,
    mi.nick_name,
    mi.avatar_url,
    mi.mobile_phone 
FROM
    dgtools_pay_order AS po
    LEFT JOIN biz_member_info AS mi ON po.member_id = mi.member_id 
WHERE
    1 = 1 
    << AND po.member_id = :memberId  >>
    << AND po.marketing_game_flow_no = :marketingGameFlowNo >>
    << AND po.pay_order_type = :payOrderType >>
    << AND po.pay_order_sn = :payOrderSn >>
    << AND po.order_status = :orderStatus >>
    << AND po.corp_info_id = :corpInfoId >>
    << AND po.sharer_id = :sharerId >>
    << AND po.is_deleted = 'N' >>
ORDER BY pay_time DESC