package cn.com.poc.thirdparty.resource.simultanous_interpretation.service;


import cn.com.poc.thirdparty.resource.simultanous_interpretation.entity.AsrOfflineDetailResult;
import cn.com.poc.thirdparty.resource.simultanous_interpretation.entity.GetDetailResult;

/**
 * 语音识别服务
 */
public interface ASRService {

    /**
     * 语音识别 / 离线文件
     *
     * @param sessionId 唯一主键ID 长度不超过200位字符
     * @param fileUrl   音频文件地址 文件不超过500M
     * @return "success"提交成功
     */
    String speechToText(String sessionId, String fileUrl);


    /**
     * 获取离线语音识别状态
     *
     * @param sessionId 唯一主键
     * @return
     */
    AsrOfflineDetailResult getDetail(String sessionId);


    /**
     * 获取离线语音识别状态 - 响应所有信息 [code,message,data]
     *
     * @param sessionId 唯一主键
     * @return
     */
    GetDetailResult getDetailByFullInformation(String sessionId);

}
