package cn.com.poc.thirdparty.resource.simultanous_interpretation.service.impl;

import cn.com.poc.common.utils.DocumentLoad;
import cn.com.poc.thirdparty.resource.simultanous_interpretation.api.ASRApi;
import cn.com.poc.thirdparty.resource.simultanous_interpretation.entity.AsrOfflineDetailResult;
import cn.com.poc.thirdparty.resource.simultanous_interpretation.entity.GetDetailResult;
import cn.com.poc.thirdparty.resource.simultanous_interpretation.entity.SpeechToTextResult;
import cn.com.poc.thirdparty.resource.simultanous_interpretation.service.ASRService;
import cn.com.yict.framemax.core.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.File;

@Service
public class ASRServiceImpl implements ASRService {

    private final Logger logger = LoggerFactory.getLogger(ASRServiceImpl.class);


    @Resource
    private ASRApi asrApi;


    @Override
    public AsrOfflineDetailResult getDetail(String sessionId) {
        GetDetailResult detail = asrApi.getDetail(sessionId);
        if (detail == null) {
            logger.error("---- 查询语音识别任务异常，响应结果为空 --------");
            throw new BusinessException("查询语音识别任务异常");
        }
        if (0 != detail.getCode()) {
            logger.error("---- 查询语音识别任务异常,message:{} -----", detail.getMessage());
            throw new BusinessException("查询语音识别任务异常");
        }
        return detail.getData();
    }

    @Override
    public GetDetailResult getDetailByFullInformation(String sessionId) {
        return asrApi.getDetail(sessionId);
    }

    @Override
    public String speechToText(String sessionId, String fileUrl) {
        File file = DocumentLoad.downloadURLDocument(fileUrl);
        SpeechToTextResult speechToTextResult = asrApi.speechToText(sessionId, file);
        if (speechToTextResult == null) {
            logger.error("-------- 语音识别任务异常，响应结果为空 ---------");
            throw new BusinessException("语音识别任务异常");
        }
        if (0 != speechToTextResult.getCode()) {
            logger.error("---- 语音识别任务异常,message:{} -----", speechToTextResult.getMessage());
            throw new BusinessException("语音识别任务异常");
        }
        return speechToTextResult.getData();
    }
}
