package cn.com.poc.thirdparty.resource.text_in.entity.doc_flow;

import java.time.OffsetDateTime;

/**
 * @Author：Roger Wu
 * @name：FileFetch
 * @Date：2025-08-29 15:20
 */
public class FileFetchRequest {

    /**
     * 批次编号
     */
    private String batchNumber;
    /**
     * 文件类别
     */
    private String category;
    /**
     * 以更新时间搜索的结束时间, RFC3339格式(YYYY-MM-DDTHH:MM:SSZ)
     */
    private OffsetDateTime endTime;
    /**
     * 文件ID
     */
    private String fileid;
    /**
     * 页码，默认1
     */
    private Long page;
    /**
     * 每页数量，默认1000
     */
    private Long pageSize;
    /**
     * 文件识别状态 0: 待识别 1: 识别成功 2: 识别失败
     */
    private Long recognitionStatus;
    /**
     * 以更新时间搜索的开始时间, RFC3339格式(YYYY-MM-DDTHH:MM:SSZ)
     */
    private OffsetDateTime startTime;
    /**
     * 文件核对状态 0: 待核对 2: 已确认 3: 已拒绝 4: 已删除 5: 推迟处理
     */
    private Long verificationStatus;
    /**
     * 是否返回文档的全部文字识别结果
     */
    private Boolean withDocument;
    /**
     * 空间ID
     */
    private String workspaceid;

    public String getBatchNumber() { return batchNumber; }
    public void setBatchNumber(String value) { this.batchNumber = value; }

    public String getCategory() { return category; }
    public void setCategory(String value) { this.category = value; }

    public OffsetDateTime getEndTime() { return endTime; }
    public void setEndTime(OffsetDateTime value) { this.endTime = value; }

    public String getFileid() { return fileid; }
    public void setFileid(String value) { this.fileid = value; }

    public Long getPage() { return page; }
    public void setPage(Long value) { this.page = value; }

    public Long getPageSize() { return pageSize; }
    public void setPageSize(Long value) { this.pageSize = value; }

    public Long getRecognitionStatus() { return recognitionStatus; }
    public void setRecognitionStatus(Long value) { this.recognitionStatus = value; }

    public OffsetDateTime getStartTime() { return startTime; }
    public void setStartTime(OffsetDateTime value) { this.startTime = value; }

    public Long getVerificationStatus() { return verificationStatus; }
    public void setVerificationStatus(Long value) { this.verificationStatus = value; }

    public Boolean getWithDocument() { return withDocument; }
    public void setWithDocument(Boolean value) { this.withDocument = value; }

    public String getWorkspaceid() { return workspaceid; }
    public void setWorkspaceid(String value) { this.workspaceid = value; }


}
