package cn.com.poc.thirdparty.resource.tianju.api;

import org.apache.http.Header;
import org.apache.http.HttpHeaders;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicHeader;

/**
 * 天聚基础API
 */
public interface TianBaseApi {

    /**
     * 基础地址
     */
    String BASE_API = "https://apis.tianapi.com/";

    /**
     * 百度热搜榜
     */
    String BAIDU_TOP_SEARCH = BASE_API + "nethot/index";

    /**
     * 头条热搜榜
     */
    String TOUTIAO_TOP_SEARCH = BASE_API + "toutiaohot/index";

    /**
     * 抖音热搜榜
     */
    String DOUYIN_TOP_SEARCH = BASE_API + "douyinhot/index";

    /**
     * 微博热搜榜
     */
    String WEIBO_TOP_SEARCH = BASE_API + "weibohot/index";

    /**
     * 全网热搜榜
     */
    String NETWORK_TOP_SEARCH = BASE_API + "networkhot/index";

    /**
     * 微信热搜榜
     */
    String WX_TOP_SEARCH = BASE_API + "wxhottopic/index";

    /**
     * 今日头条热门新闻
     */
    String TOUTIAO_TOP_NEWS_SEARCH = BASE_API + "topnews/index";

    /**
     * 微信文章精选
     */
    String WX_NEW_SEARCH = BASE_API + "wxnew/index";

    /**
     * 分类新闻
     */
    String ALLNEWS_SEARCH = BASE_API + "allnews/index";

    /**
     * key参数
     */
    String KEY = "key";

    String KEY_SITE = "tianju.key";

    /**
     * num参数
     */
    String NUM = "num";

    /**
     * col参数
     */
    String COL = "col";

    /**
     * rand参数
     */
    String RAND = "rand";

    /**
     * word参数
     */
    String WORD = "word";

    /**
     * page参数
     */
    String PAGE = "page";

    /**
     * 通用头信息
     */
    Header urlencodedHeader = new BasicHeader(HttpHeaders.CONTENT_TYPE, ContentType.APPLICATION_FORM_URLENCODED.toString());


}
