package cn.com.poc.thirdparty.resource.tianju.api.constant;

/**
 * 天聚api请求错误状态码枚举
 */
public enum TianApiErrorCodeEnum {
    SERVER_ERROR(100,"内部服务器错误"),
    API_IS_OFFLINE(110,"当前API已下线"),
    API_IS_MAINTENANCE(120,"API暂时维护中"),
    API_CALL_OUT_LIMIT(130,"API调用超限"),
    API_NOT_HAVE_CALL_PERMISSION(140,"API没有调用权限"),
    API_NOT_ENOUGH_AVAILABLE(150,"API可用次数不足"),
    ACCOUNT_NOT_SUBSCRIBED_API(160,"账号未申请该API"),
    REFERER_REQUEST_LIMITED(170,"Referer请求来源受限"),
    IP_REQUEST_LIMITED(180,"IP请求来源受限"),
    KEY_NOT_AVAILABLE(190,"当前key不可用"),
    KEY_WRONG_OR_EMPTY(230,"key错误或为空"),
    KEY_MISSING_PARAMETER(240,"缺少key参数"),
    DATA_RETURN_EMPTY(250,"数据返回为空"),
    PARAMETER_NOT_BE_EMPTY(260,"参数值不得为空"),
    PARAMETER_NOT_MEET_REQUIREMENT(270,"参数值不符合要求"),
    MISSING_NECESSARY_PARAMETER(280,"缺少必要的参数"),
    EXCEED_INPUT_LIMIT(290,"超过最大输入限制");

    private final Integer errorCode;

    private final String errorMessage;

    TianApiErrorCodeEnum(Integer errorCode , String errorMessage){
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    public Integer getErrorCode() {
        return errorCode;
    }

    public String getErrorMessage() {
        return errorMessage;
    }
}
